/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.ext.editor.commons.file.exports;

import java.lang.RuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.preferences.shared.annotations.PortablePreference;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.PropertyFormType;
import org.uberfire.preferences.shared.PropertyValidator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Portable( mapSuperTypes = true )
@PortablePreference
@Generated("org.uberfire.ext.preferences.processors.WorkbenchPreferenceProcessor")
/*
* WARNING! This class is generated. Do not modify.
*/
public class FileExportsPreferencesPortableGeneratedImpl extends FileExportsPreferences implements BasePreferencePortable<FileExportsPreferences> {

    public FileExportsPreferencesPortableGeneratedImpl() {
    }

    public FileExportsPreferencesPortableGeneratedImpl( @MapsTo("pdfOrientation") java.lang.String pdfOrientation, @MapsTo("pdfUnit") java.lang.String pdfUnit, @MapsTo("pdfFormat") java.lang.String pdfFormat ) {
        this.pdfOrientation = pdfOrientation;
        this.pdfUnit = pdfUnit;
        this.pdfFormat = pdfFormat;
    }

    @Override
    public Class<FileExportsPreferences> getPojoClass() {
        return FileExportsPreferences.class;
    }

    @Override
    public String identifier() {
        return "FileExport";
    }

    @Override
    public String[] parents() {
        return new String[] { "LibraryPreferences" };
    }

    @Override
    public String bundleKey() {
        return "FileExport.Label";
    }

    @Override
    public void set( String property, Object value ) {
        if ( property.equals( "pdfOrientation" ) ) {
            pdfOrientation = (java.lang.String) value;
        } else
        if ( property.equals( "pdfUnit" ) ) {
            pdfUnit = (java.lang.String) value;
        } else
        if ( property.equals( "pdfFormat" ) ) {
            pdfFormat = (java.lang.String) value;
        } else
        {
            throw new RuntimeException( "Unknown property: " + property );
        }
    }

    @Override
    public Object get( String property ) {
        if ( property.equals( "pdfOrientation" ) ) {
            return pdfOrientation;
        } else
        if ( property.equals( "pdfUnit" ) ) {
            return pdfUnit;
        } else
        if ( property.equals( "pdfFormat" ) ) {
            return pdfFormat;
        } else
        {
            throw new RuntimeException( "Unknown property: " + property );
        }
    }

    @Override
    public Map<String, PropertyFormType> getPropertiesTypes() {
        Map<String, PropertyFormType> propertiesTypes = new HashMap<>();

        propertiesTypes.put( "pdfOrientation", PropertyFormType.TEXT);
        propertiesTypes.put( "pdfUnit", PropertyFormType.TEXT);
        propertiesTypes.put( "pdfFormat", PropertyFormType.TEXT);

        return propertiesTypes;
    }

    @Override
    public Map<String, List<PropertyValidator>> getPropertiesValidators() {
        Map<String, List<PropertyValidator>> validatorsByProperty = new HashMap<>();

        List<PropertyValidator> validatorsPdfOrientation = new ArrayList<>();
        validatorsPdfOrientation.add(new org.uberfire.ext.editor.commons.file.exports.PdfOrientationValidator());
        validatorsByProperty.put("pdfOrientation", validatorsPdfOrientation);

        List<PropertyValidator> validatorsPdfUnit = new ArrayList<>();
        validatorsPdfUnit.add(new org.uberfire.ext.editor.commons.file.exports.PdfUnitValidator());
        validatorsByProperty.put("pdfUnit", validatorsPdfUnit);

        List<PropertyValidator> validatorsPdfFormat = new ArrayList<>();
        validatorsPdfFormat.add(new org.uberfire.ext.editor.commons.file.exports.PdfFormatValidator());
        validatorsByProperty.put("pdfFormat", validatorsPdfFormat);


        return validatorsByProperty;
    }

    @Override
    public boolean equals( final Object o ) {
        if ( this == o ) {
            return true;
        }
        if ( o == null || getClass() != o.getClass() ) {
            return false;
        }

        final FileExportsPreferencesPortableGeneratedImpl that = (FileExportsPreferencesPortableGeneratedImpl) o;

        if ( pdfOrientation != null ? !pdfOrientation.equals( that.pdfOrientation ) : that.pdfOrientation != null ) {
            return false;
        }
        if ( pdfUnit != null ? !pdfUnit.equals( that.pdfUnit ) : that.pdfUnit != null ) {
            return false;
        }
        if ( pdfFormat != null ? !pdfFormat.equals( that.pdfFormat ) : that.pdfFormat != null ) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;

        result = 31 * result + ( pdfOrientation != null ? pdfOrientation.hashCode() : 0 );
        result = ~~result;
        result = 31 * result + ( pdfUnit != null ? pdfUnit.hashCode() : 0 );
        result = ~~result;
        result = 31 * result + ( pdfFormat != null ? pdfFormat.hashCode() : 0 );
        result = ~~result;

        return result;
    }

    @Override
    public boolean isPersistable() {
        return true;
    }
}
