/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.helper.DeleteHelper;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.restriction.PathOperationRestriction;
import org.uberfire.ext.editor.commons.service.restrictor.DeleteRestrictor;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class DeleteServiceImpl
implements DeleteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteServiceImpl.class);
    private IOService ioService;
    private User identity;
    private SessionInfo sessionInfo;
    private Instance<DeleteHelper> helpers;
    private Instance<DeleteRestrictor> deleteRestrictorBeans;

    public DeleteServiceImpl() {
    }

    @Inject
    public DeleteServiceImpl(@Named(value="ioStrategy") IOService ioService, User identity, SessionInfo sessionInfo, Instance<DeleteHelper> helpers, Instance<DeleteRestrictor> deleteRestrictorBeans) {
        this.ioService = ioService;
        this.identity = identity;
        this.sessionInfo = sessionInfo;
        this.helpers = helpers;
        this.deleteRestrictorBeans = deleteRestrictorBeans;
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        LOGGER.info("User:" + this.identity.getIdentifier() + " deleting file [" + path.getFileName() + "]");
        this.checkRestrictions(path);
        try {
            this.deletePath(path, comment);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteIfExists(Collection<org.uberfire.backend.vfs.Path> paths, String comment) {
        try {
            this.startBatch(paths);
            for (org.uberfire.backend.vfs.Path path : paths) {
                LOGGER.info("User:" + this.identity.getIdentifier() + " deleting file (if exists) [" + path.getFileName() + "]");
                this.checkRestrictions(path);
                this.deletePathIfExists(path, comment);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.endBatch(paths);
        }
    }

    public boolean hasRestriction(org.uberfire.backend.vfs.Path path) {
        for (DeleteRestrictor deleteRestrictor : this.getDeleteRestrictors()) {
            PathOperationRestriction deleteRestriction = deleteRestrictor.hasRestriction(path);
            if (deleteRestriction == null) continue;
            return true;
        }
        return false;
    }

    private void checkRestrictions(org.uberfire.backend.vfs.Path path) {
        for (DeleteRestrictor deleteRestrictor : this.getDeleteRestrictors()) {
            PathOperationRestriction deleteRestriction = deleteRestrictor.hasRestriction(path);
            if (deleteRestriction == null) continue;
            throw new RuntimeException(deleteRestriction.getMessage(path));
        }
    }

    void deletePath(org.uberfire.backend.vfs.Path path, String comment) {
        Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
        try {
            this.ioService.startBatch(_path.getFileSystem());
            this.notifyDeleteHelpers(path);
            this.ioService.delete(Paths.convert((org.uberfire.backend.vfs.Path)path), new DeleteOption[]{new CommentedOption(this.sessionInfo != null ? this.sessionInfo.getId() : "--", this.identity.getIdentifier(), null, comment)});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    void deletePathIfExists(org.uberfire.backend.vfs.Path path, String comment) {
        this.notifyDeleteHelpers(path);
        this.ioService.deleteIfExists(Paths.convert((org.uberfire.backend.vfs.Path)path), new DeleteOption[]{new CommentedOption(this.sessionInfo.getId(), this.identity.getIdentifier(), null, comment), StandardDeleteOption.NON_EMPTY_DIRECTORIES});
    }

    void notifyDeleteHelpers(org.uberfire.backend.vfs.Path path) {
        Iterable<DeleteHelper> helpers = this.getDeleteHelpers();
        if (helpers != null) {
            for (DeleteHelper helper : helpers) {
                if (!helper.supports(path)) continue;
                helper.postProcess(path);
            }
        }
    }

    void startBatch(Collection<org.uberfire.backend.vfs.Path> paths) {
        if (paths.size() > 1) {
            this.ioService.startBatch(Paths.convert((org.uberfire.backend.vfs.Path)paths.iterator().next()).getFileSystem());
        }
    }

    void endBatch(Collection<org.uberfire.backend.vfs.Path> paths) {
        if (paths.size() > 1) {
            this.ioService.endBatch();
        }
    }

    Iterable<DeleteRestrictor> getDeleteRestrictors() {
        return this.deleteRestrictorBeans;
    }

    Iterable<DeleteHelper> getDeleteHelpers() {
        return this.helpers;
    }
}

