/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.helper.CopyHelper;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.PathNamingService;
import org.uberfire.ext.editor.commons.service.restriction.PathOperationRestriction;
import org.uberfire.ext.editor.commons.service.restrictor.CopyRestrictor;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.workbench.events.ResourceCopiedEvent;

@Service
@ApplicationScoped
public class CopyServiceImpl
implements CopyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyServiceImpl.class);
    private IOService ioService;
    private User identity;
    private SessionInfo sessionInfo;
    private Instance<CopyHelper> helpers;
    private Event<ResourceCopiedEvent> resourceCopiedEvent;
    private Instance<CopyRestrictor> copyRestrictorBeans;
    private PathNamingService pathNamingService;

    public CopyServiceImpl() {
    }

    @Inject
    public CopyServiceImpl(@Named(value="ioStrategy") IOService ioService, User identity, SessionInfo sessionInfo, Instance<CopyHelper> helpers, Event<ResourceCopiedEvent> resourceCopiedEvent, Instance<CopyRestrictor> copyRestrictorBeans, PathNamingService pathNamingService) {
        this.ioService = ioService;
        this.identity = identity;
        this.sessionInfo = sessionInfo;
        this.helpers = helpers;
        this.resourceCopiedEvent = resourceCopiedEvent;
        this.copyRestrictorBeans = copyRestrictorBeans;
        this.pathNamingService = pathNamingService;
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        LOGGER.info("User:" + this.identity.getIdentifier() + " copying file [" + path.getFileName() + "] to [" + newName + "]");
        this.checkRestrictions(path);
        try {
            org.uberfire.backend.vfs.Path targetPath = this.pathNamingService.buildTargetPath(path, newName);
            return this.copyPath(path, newName, targetPath, comment);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        if (targetDirectory == null) {
            return this.copy(path, newName, comment);
        }
        LOGGER.info("User:" + this.identity.getIdentifier() + " copying file [" + path.getFileName() + "] to [" + newName + "]");
        this.checkRestrictions(path);
        try {
            org.uberfire.backend.vfs.Path targetPath = this.pathNamingService.buildTargetPath(path, targetDirectory, newName);
            return this.copyPath(path, newName, targetPath, comment);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void copyIfExists(Collection<org.uberfire.backend.vfs.Path> paths, String newName, String comment) {
        try {
            this.startBatch(paths);
            for (org.uberfire.backend.vfs.Path path : paths) {
                LOGGER.info("User:" + this.identity.getIdentifier() + " copying file (if exists) [" + path.getFileName() + "] to [" + newName + "]");
                this.checkRestrictions(path);
                this.copyPathIfExists(path, newName, comment);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.endBatch();
        }
    }

    public boolean hasRestriction(org.uberfire.backend.vfs.Path path) {
        for (CopyRestrictor copyRestrictor : this.getCopyRestrictors()) {
            PathOperationRestriction copyRestriction = copyRestrictor.hasRestriction(path);
            if (copyRestriction == null) continue;
            return true;
        }
        return false;
    }

    private void checkRestrictions(org.uberfire.backend.vfs.Path path) {
        for (CopyRestrictor copyRestrictor : this.getCopyRestrictors()) {
            PathOperationRestriction copyRestriction = copyRestrictor.hasRestriction(path);
            if (copyRestriction == null) continue;
            throw new RuntimeException(copyRestriction.getMessage(path));
        }
    }

    org.uberfire.backend.vfs.Path copyPath(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetPath, String comment) {
        Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
        Path _target = Paths.convert((org.uberfire.backend.vfs.Path)targetPath);
        try {
            this.ioService.startBatch(_target.getFileSystem());
            this.ioService.copy(_path, _target, new CopyOption[]{new CommentedOption(this.sessionInfo != null ? this.sessionInfo.getId() : "--", this.identity.getIdentifier(), null, comment)});
            if (this.helpers != null) {
                for (CopyHelper helper : this.helpers) {
                    if (!helper.supports(targetPath)) continue;
                    helper.postProcess(path, targetPath);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.endBatch();
        }
        this.resourceCopiedEvent.fire((Object)new ResourceCopiedEvent(path, targetPath, comment, (SessionInfo)(this.sessionInfo != null ? this.sessionInfo : new SessionInfoImpl("--", this.identity))));
        return targetPath;
    }

    void copyPathIfExists(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (Files.exists((Path)_path, (LinkOption[])new LinkOption[0])) {
            Path _target = Paths.convert((org.uberfire.backend.vfs.Path)this.pathNamingService.buildTargetPath(path, newName));
            this.ioService.copy(_path, _target, new CopyOption[]{new CommentedOption(this.sessionInfo.getId(), this.identity.getIdentifier(), null, comment)});
            if (_target != null && this.helpers != null) {
                org.uberfire.backend.vfs.Path targetPath = Paths.convert((Path)_target);
                for (CopyHelper helper : this.helpers) {
                    if (!helper.supports(targetPath)) continue;
                    helper.postProcess(path, targetPath);
                }
            }
        }
    }

    void startBatch(Collection<org.uberfire.backend.vfs.Path> paths) {
        this.ioService.startBatch(Paths.convert((org.uberfire.backend.vfs.Path)paths.iterator().next()).getFileSystem());
    }

    void endBatch() {
        this.ioService.endBatch();
    }

    Iterable<CopyRestrictor> getCopyRestrictors() {
        return this.copyRestrictorBeans;
    }
}

