/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kie.soup.commons.validation.PortablePreconditions;

public class ConfigProperties {
    private final Map<String, String> configuredValues;
    private final List<ConfigProperty> configSummary = new ArrayList<ConfigProperty>();

    public ConfigProperties(Map<String, String> configuredValues) {
        this.configuredValues = (Map)PortablePreconditions.checkNotNull((String)"configuredValues", configuredValues);
    }

    public ConfigProperties(Properties configuredValues) {
        HashMap<String, String> stringProperties = new HashMap<String, String>();
        for (String key : configuredValues.stringPropertyNames()) {
            stringProperties.put(key, configuredValues.getProperty(key));
        }
        this.configuredValues = stringProperties;
    }

    public ConfigProperty get(String name, String defaultValue) {
        String val = this.configuredValues.get(name);
        ConfigProperty cp = val == null || val.trim().length() == 0 ? new ConfigProperty(name, defaultValue, true) : new ConfigProperty(name, val.trim(), false);
        this.configSummary.add(cp);
        return cp;
    }

    public String getConfigurationSummary(String heading) {
        String newLine = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder(heading);
        for (ConfigProperty cp : this.configSummary) {
            sb.append(newLine).append(cp);
        }
        return sb.toString();
    }

    public static class ConfigProperty {
        private final String name;
        private final String value;
        private final boolean isDefault;

        ConfigProperty(String name, String value, boolean isDefault) {
            this.name = name;
            this.value = value;
            this.isDefault = isDefault;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean getBooleanValue() {
            return Boolean.valueOf(this.value);
        }

        public int getIntValue() {
            return Integer.parseInt(this.value);
        }

        public String toString() {
            return this.name + " = \"" + this.value + "\"" + (this.isDefault ? " (Defaulted)" : "");
        }
    }
}

