/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.layout.editor.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.ext.layout.editor.api.LayoutServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

@Service
@ApplicationScoped
public class LayoutServicesImpl
implements LayoutServices {
    private Gson gson;

    @PostConstruct
    public void init() {
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public String convertLayoutToString(LayoutTemplate layoutTemplate) {
        String layoutContent = this.gson.toJson((Object)layoutTemplate);
        return layoutContent;
    }

    public LayoutTemplate convertLayoutFromString(String layoutEditorModel) {
        try {
            if (this.needsUpgrade(layoutEditorModel)) {
                throw new RuntimeException("not yet supported");
            }
            LayoutTemplate layoutTemplate = (LayoutTemplate)this.gson.fromJson(layoutEditorModel, LayoutTemplate.class);
            return layoutTemplate;
        }
        catch (Exception e) {
            return new LayoutTemplate();
        }
    }

    private boolean needsUpgrade(String layoutEditorModel) {
        return false;
    }
}

