/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.guvnor.m2repo.preferences;

import java.lang.RuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.preferences.shared.annotations.PortablePreference;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.PropertyFormType;
import org.uberfire.preferences.shared.PropertyValidator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Portable( mapSuperTypes = true )
@PortablePreference
@Generated("org.uberfire.ext.preferences.processors.WorkbenchPreferenceProcessor")
/*
* WARNING! This class is generated. Do not modify.
*/
public class ArtifactRepositoryPreferencePortableGeneratedImpl extends ArtifactRepositoryPreference implements BasePreferencePortable<ArtifactRepositoryPreference> {

    public ArtifactRepositoryPreferencePortableGeneratedImpl() {
    }

    public ArtifactRepositoryPreferencePortableGeneratedImpl( @MapsTo("globalM2RepoDir") java.lang.String globalM2RepoDir, @MapsTo("globalM2RepoDirEnabled") boolean globalM2RepoDirEnabled, @MapsTo("workspaceM2RepoDir") java.lang.String workspaceM2RepoDir, @MapsTo("workspaceM2RepoDirEnabled") boolean workspaceM2RepoDirEnabled, @MapsTo("distributionManagementM2RepoDirEnabled") boolean distributionManagementM2RepoDirEnabled ) {
        setGlobalM2RepoDir( globalM2RepoDir );
        setGlobalM2RepoDirEnabled( globalM2RepoDirEnabled );
        setWorkspaceM2RepoDir( workspaceM2RepoDir );
        setWorkspaceM2RepoDirEnabled( workspaceM2RepoDirEnabled );
        setDistributionManagementM2RepoDirEnabled( distributionManagementM2RepoDirEnabled );
    }

    @Override
    public Class<ArtifactRepositoryPreference> getPojoClass() {
        return ArtifactRepositoryPreference.class;
    }

    @Override
    public String identifier() {
        return "ArtifactRepositoryPreference";
    }

    @Override
    public String[] parents() {
        return new String[] { "" };
    }

    @Override
    public String bundleKey() {
        return "ArtifactRepositoryPreference.Label";
    }

    @Override
    public void set( String property, Object value ) {
        if ( property.equals( "globalM2RepoDir" ) ) {
            setGlobalM2RepoDir( (java.lang.String) value );
        } else
        if ( property.equals( "globalM2RepoDirEnabled" ) ) {
            setGlobalM2RepoDirEnabled( (boolean) value );
        } else
        if ( property.equals( "workspaceM2RepoDir" ) ) {
            setWorkspaceM2RepoDir( (java.lang.String) value );
        } else
        if ( property.equals( "workspaceM2RepoDirEnabled" ) ) {
            setWorkspaceM2RepoDirEnabled( (boolean) value );
        } else
        if ( property.equals( "distributionManagementM2RepoDirEnabled" ) ) {
            setDistributionManagementM2RepoDirEnabled( (boolean) value );
        } else
        {
            throw new RuntimeException( "Unknown property: " + property );
        }
    }

    @Override
    public Object get( String property ) {
        if ( property.equals( "globalM2RepoDir" ) ) {
            return getGlobalM2RepoDir();
        } else
        if ( property.equals( "globalM2RepoDirEnabled" ) ) {
            return isGlobalM2RepoDirEnabled();
        } else
        if ( property.equals( "workspaceM2RepoDir" ) ) {
            return getWorkspaceM2RepoDir();
        } else
        if ( property.equals( "workspaceM2RepoDirEnabled" ) ) {
            return isWorkspaceM2RepoDirEnabled();
        } else
        if ( property.equals( "distributionManagementM2RepoDirEnabled" ) ) {
            return isDistributionManagementM2RepoDirEnabled();
        } else
        {
            throw new RuntimeException( "Unknown property: " + property );
        }
    }

    @Override
    public Map<String, PropertyFormType> getPropertiesTypes() {
        Map<String, PropertyFormType> propertiesTypes = new HashMap<>();

        propertiesTypes.put( "globalM2RepoDir", PropertyFormType.TEXT);
        propertiesTypes.put( "globalM2RepoDirEnabled", PropertyFormType.BOOLEAN);
        propertiesTypes.put( "workspaceM2RepoDir", PropertyFormType.TEXT);
        propertiesTypes.put( "workspaceM2RepoDirEnabled", PropertyFormType.BOOLEAN);
        propertiesTypes.put( "distributionManagementM2RepoDirEnabled", PropertyFormType.BOOLEAN);

        return propertiesTypes;
    }

    @Override
    public Map<String, List<PropertyValidator>> getPropertiesValidators() {
        Map<String, List<PropertyValidator>> validatorsByProperty = new HashMap<>();

        List<PropertyValidator> validatorsGlobalM2RepoDir = new ArrayList<>();
        validatorsGlobalM2RepoDir.add(new org.uberfire.preferences.shared.impl.validation.NotEmptyValidator());
        validatorsByProperty.put("globalM2RepoDir", validatorsGlobalM2RepoDir);

        List<PropertyValidator> validatorsWorkspaceM2RepoDir = new ArrayList<>();
        validatorsWorkspaceM2RepoDir.add(new org.uberfire.preferences.shared.impl.validation.NotEmptyValidator());
        validatorsByProperty.put("workspaceM2RepoDir", validatorsWorkspaceM2RepoDir);


        return validatorsByProperty;
    }

    @Override
    public boolean equals( final Object o ) {
        if ( this == o ) {
            return true;
        }
        if ( o == null || getClass() != o.getClass() ) {
            return false;
        }

        final ArtifactRepositoryPreferencePortableGeneratedImpl that = (ArtifactRepositoryPreferencePortableGeneratedImpl) o;

        if ( getGlobalM2RepoDir() != null ? !getGlobalM2RepoDir().equals( that.getGlobalM2RepoDir() ) : that.getGlobalM2RepoDir() != null ) {
            return false;
        }
        if ( isGlobalM2RepoDirEnabled() != that.isGlobalM2RepoDirEnabled() ) {
            return false;
        }
        if ( getWorkspaceM2RepoDir() != null ? !getWorkspaceM2RepoDir().equals( that.getWorkspaceM2RepoDir() ) : that.getWorkspaceM2RepoDir() != null ) {
            return false;
        }
        if ( isWorkspaceM2RepoDirEnabled() != that.isWorkspaceM2RepoDirEnabled() ) {
            return false;
        }
        if ( isDistributionManagementM2RepoDirEnabled() != that.isDistributionManagementM2RepoDirEnabled() ) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;

        result = 31 * result + ( getGlobalM2RepoDir() != null ? getGlobalM2RepoDir().hashCode() : 0 );
        result = ~~result;
        result = 31 * result + java.lang.Boolean.hashCode( isGlobalM2RepoDirEnabled() );
        result = ~~result;
        result = 31 * result + ( getWorkspaceM2RepoDir() != null ? getWorkspaceM2RepoDir().hashCode() : 0 );
        result = ~~result;
        result = 31 * result + java.lang.Boolean.hashCode( isWorkspaceM2RepoDirEnabled() );
        result = ~~result;
        result = 31 * result + java.lang.Boolean.hashCode( isDistributionManagementM2RepoDirEnabled() );
        result = ~~result;

        return result;
    }

    @Override
    public boolean isPersistable() {
        return true;
    }
}
