/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.patch.FileHeader;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.base.FileDiff;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class DiffBranches {
    private final Git git;
    private final String branchA;
    private final String branchB;

    public DiffBranches(Git git, String branchA, String branchB) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.branchA = PortablePreconditions.checkNotEmpty((String)"branchA", (String)branchA);
        this.branchB = PortablePreconditions.checkNotEmpty((String)"branchB", (String)branchB);
    }

    public List<FileDiff> execute() {
        ArrayList<FileDiff> diffs = new ArrayList<FileDiff>();
        List<DiffEntry> result = this.git.listDiffs(this.git.getTreeFromRef(this.branchA), this.git.getTreeFromRef(this.branchB));
        DiffFormatter formatter = this.createFormatter();
        result.forEach(elem -> {
            FileHeader header = this.getFileHeader(formatter, (DiffEntry)elem);
            header.toEditList().forEach(edit -> diffs.add(this.createFileDiff((DiffEntry)elem, header, (Edit)edit)));
        });
        return diffs;
    }

    private FileHeader getFileHeader(DiffFormatter formatter, DiffEntry elem) {
        try {
            return formatter.toFileHeader(elem);
        }
        catch (IOException e) {
            throw new GitException("A problem occurred when trying to obtain diffs between files", e);
        }
    }

    private DiffFormatter createFormatter() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DiffFormatter formatter = new DiffFormatter((OutputStream)outputStream);
        formatter.setRepository(this.git.getRepository());
        return formatter;
    }

    private FileDiff createFileDiff(DiffEntry elem, FileHeader header, Edit edit) {
        try {
            String changeType = header.getChangeType().toString();
            int startA = edit.getBeginA();
            int endA = edit.getEndA();
            int startB = edit.getBeginB();
            int endB = edit.getEndB();
            String pathA = header.getOldPath();
            String pathB = header.getNewPath();
            List<String> linesA = this.getLines(elem.getOldId().toObjectId(), startA, endA);
            List<String> linesB = this.getLines(elem.getNewId().toObjectId(), startB, endB);
            return new FileDiff(pathA, pathB, startA, endA, startB, endB, changeType, linesA, linesB);
        }
        catch (IOException e) {
            throw new GitException("A problem occurred when trying to obtain diffs between files", e);
        }
    }

    private List<String> getLines(ObjectId id, int fromStart, int fromEnd) throws IOException {
        List<String> lines = new ArrayList<String>();
        if (!id.equals((AnyObjectId)ObjectId.zeroId())) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ObjectLoader loader = this.git.getRepository().open((AnyObjectId)id);
            loader.copyTo((OutputStream)stream);
            String content = stream.toString();
            List<String> filteredLines = Arrays.asList(content.split("\n"));
            lines = filteredLines.subList(fromStart, fromEnd);
        }
        return lines;
    }
}

