/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.lib.Ref;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.fs.jgit.util.GitImpl;

public class SyncRemote {
    private final GitImpl git;
    private final Pair<String, String> remote;

    public SyncRemote(GitImpl git, Pair<String, String> remote) {
        this.git = git;
        this.remote = remote;
    }

    public Optional execute() throws InvalidRemoteException {
        try {
            List branches = this.git._branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            HashSet<String> remoteBranches = new HashSet<String>();
            HashSet<String> localBranches = new HashSet<String>();
            this.fillBranches(branches, remoteBranches, localBranches);
            for (String localBranch : localBranches) {
                if (localBranch.equals("HEAD") || !remoteBranches.contains(localBranch)) continue;
                try {
                    this.git._branchCreate().setName(localBranch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint((String)this.remote.getK1() + "/" + localBranch).setForce(true).call();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error creating branch [" + localBranch + "].");
                }
            }
            remoteBranches.removeAll(localBranches);
            for (String branch : remoteBranches) {
                if (branch.equals("HEAD")) continue;
                try {
                    this.git._branchCreate().setName(branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint((String)this.remote.getK1() + "/" + branch).setForce(true).call();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error creating branch [" + branch + "].");
                }
            }
            return null;
        }
        catch (InvalidRemoteException e) {
            throw e;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void fillBranches(List<Ref> branches, Collection<String> remoteBranches, Collection<String> localBranches) {
        for (Ref branch : branches) {
            String branchFullName = branch.getName();
            String remotePrefix = "refs/remotes/" + (String)this.remote.getK1() + "/";
            String localPrefix = "refs/heads/";
            if (branchFullName.startsWith(remotePrefix)) {
                remoteBranches.add(branchFullName.replaceFirst(remotePrefix, ""));
                continue;
            }
            if (branchFullName.startsWith("refs/heads/")) {
                localBranches.add(branchFullName.replaceFirst("refs/heads/", ""));
                continue;
            }
            localBranches.add(branchFullName.substring(branchFullName.lastIndexOf("/") + 1));
        }
    }
}

