/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.events.DeleteModuleEvent;
import org.guvnor.common.services.project.model.Module;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceDeleted;
import org.uberfire.workbench.events.ResourceDeletedEvent;

public abstract class AbstractDeleteModuleObserverBridge<T extends Module> {
    private IOService ioService;
    private Event<DeleteModuleEvent> deleteModuleEvent;

    public AbstractDeleteModuleObserverBridge() {
    }

    public AbstractDeleteModuleObserverBridge(IOService ioService, Event<DeleteModuleEvent> deleteModuleEvent) {
        this.ioService = (IOService)PortablePreconditions.checkNotNull((String)"ioService", (Object)ioService);
        this.deleteModuleEvent = (Event)PortablePreconditions.checkNotNull((String)"deleteModuleEvent", deleteModuleEvent);
    }

    public void onBatchResourceChanges(ResourceDeletedEvent event) {
        if (event.getPath().getFileName().equals("pom.xml")) {
            this.fireDeleteEvent(event.getPath());
        }
    }

    public void onBatchResourceChanges(ResourceBatchChangesEvent resourceBatchChangesEvent) {
        for (Map.Entry entry : resourceBatchChangesEvent.getBatch().entrySet()) {
            if (!((org.uberfire.backend.vfs.Path)entry.getKey()).getFileName().equals("pom.xml") || !this.isDelete((Collection)entry.getValue())) continue;
            this.fireDeleteEvent((org.uberfire.backend.vfs.Path)entry.getKey());
        }
    }

    private boolean isDelete(Collection<ResourceChange> value) {
        for (ResourceChange resourceChange : value) {
            if (!(resourceChange instanceof ResourceDeleted)) continue;
            return true;
        }
        return false;
    }

    private void fireDeleteEvent(org.uberfire.backend.vfs.Path _path) {
        Path path = this.ioService.get(URI.create(_path.toURI()));
        T project = this.getModule(path.getParent());
        this.deleteModuleEvent.fire((Object)new DeleteModuleEvent(project));
    }

    protected abstract T getModule(Path var1);
}

