/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.plugin.backend;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.uberfire.ext.plugin.model.CodeType;
import org.uberfire.ext.plugin.model.Framework;
import org.uberfire.ext.plugin.model.PluginSimpleContent;
import org.uberfire.ext.plugin.model.PluginType;

public class JSRegistry {
    public static String convertToJSRegistry(PluginSimpleContent plugin) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        StringBuilder sb = new StringBuilder();
        if (plugin.getCodeMap().containsKey(CodeType.MAIN)) {
            sb.append((String)plugin.getCodeMap().get(CodeType.MAIN));
        }
        if (plugin.getType().equals((Object)PluginType.SCREEN)) {
            sb.append("$registerPlugin({");
        } else if (plugin.getType().equals((Object)PluginType.SPLASH)) {
            sb.append("$registerSplashScreen({");
        } else if (plugin.getType().equals((Object)PluginType.EDITOR)) {
            sb.append("$registerEditor({");
        } else if (plugin.getType().equals((Object)PluginType.PERSPECTIVE)) {
            sb.append("$registerPerspective({");
        }
        sb.append("id:").append('\"').append(plugin.getName()).append('\"').append(",");
        if (plugin.getCodeMap().size() > 1) {
            for (CodeType ct : CodeType.values()) {
                if (ct.equals((Object)CodeType.MAIN) || !plugin.getCodeMap().containsKey(ct)) continue;
                sb.append(ct.toString().toLowerCase()).append(": ");
                sb.append(JSRegistry.prepareEntryValue(ct, (String)plugin.getCodeMap().get(ct))).append(",");
            }
        }
        if (plugin.getFrameworks() != null && !plugin.getFrameworks().isEmpty()) {
            Framework fm = (Framework)plugin.getFrameworks().iterator().next();
            sb.append("type: ").append('\"').append(fm.getType()).append('\"').append(',');
        }
        if (!plugin.getType().equals((Object)PluginType.PERSPECTIVE)) {
            sb.append("template: ");
            gson.toJson((Object)plugin.getTemplate(), (Appendable)sb);
        } else {
            sb.append("view: {").append(plugin.getTemplate()).append("}");
        }
        sb.append("});");
        return sb.toString();
    }

    protected static String prepareEntryValue(CodeType key, String value) {
        if (JSRegistry.isAFunction(value)) {
            return value;
        }
        return JSRegistry.prepareStringValue(key, value);
    }

    private static boolean isAFunction(String value) {
        return value != null && value.contains("function");
    }

    private static String prepareStringValue(CodeType key, String value) {
        return JSRegistry.wrapWithFunctionDeclaration(key, value);
    }

    private static String wrapWithFunctionDeclaration(CodeType key, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("function (){");
        sb.append(JSRegistry.createFunctionBody(key, value));
        sb.append(";}");
        return sb.toString();
    }

    private static String createFunctionBody(CodeType key, String value) {
        StringBuilder sb = new StringBuilder();
        if (JSRegistry.JSFunctionNeedsToReturnValue(key)) {
            sb.append("return ");
            sb.append(JSRegistry.wrapValueWithCommas(value));
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    private static String wrapValueWithCommas(String value) {
        StringBuilder sb = new StringBuilder();
        if (value == null || value.isEmpty()) {
            sb.append("\"\"");
        } else {
            if (value.charAt(0) != '\"') {
                sb.append("\"");
            }
            sb.append(value);
            if (value.charAt(value.length() - 1) != '\"') {
                sb.append("\"");
            }
        }
        return sb.toString();
    }

    public static boolean JSFunctionNeedsToReturnValue(CodeType codeType) {
        return codeType.equals((Object)CodeType.TITLE) || codeType.equals((Object)CodeType.RESOURCE_TYPE) || codeType.equals((Object)CodeType.PRIORITY) || codeType.equals((Object)CodeType.BODY_HEIGHT) || codeType.equals((Object)CodeType.INTERCEPTION_POINTS) || codeType.equals((Object)CodeType.PANEL_TYPE);
    }
}

