/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.processors;

import org.jboss.errai.codegen.BooleanExpression;
import org.jboss.errai.codegen.Statement;
import org.jboss.errai.codegen.builder.BlockBuilder;
import org.jboss.errai.codegen.builder.ContextualStatementBuilder;
import org.jboss.errai.codegen.builder.ElseBlockBuilder;
import org.jboss.errai.codegen.builder.impl.BooleanExpressionBuilder;
import org.jboss.errai.codegen.meta.MetaClass;
import org.jboss.errai.codegen.meta.MetaMethod;
import org.jboss.errai.codegen.meta.MetaParameter;
import org.jboss.errai.codegen.util.If;
import org.jboss.errai.codegen.util.Stmt;
import org.jboss.errai.ioc.client.api.CodeDecorator;
import org.jboss.errai.ioc.rebind.ioc.extension.IOCDecoratorExtension;
import org.jboss.errai.ioc.rebind.ioc.injector.api.Decorable;
import org.jboss.errai.ioc.rebind.ioc.injector.api.FactoryController;
import org.uberfire.security.Resource;
import org.uberfire.security.annotations.ResourceCheck;
import org.uberfire.security.client.authz.AuthorizationManagerHelper;

@CodeDecorator
public class ResourceCheckProcessor
extends IOCDecoratorExtension<ResourceCheck> {
    public ResourceCheckProcessor(Class<ResourceCheck> decoratesWith) {
        super(decoratesWith);
    }

    public void generateDecorator(Decorable decorable, FactoryController controller) {
        MetaMethod metaMethod = decorable.getAsMethod();
        ResourceCheck securedResource = (ResourceCheck)metaMethod.getAnnotation(ResourceCheck.class);
        String resourceType = securedResource.type();
        String resourceAction = securedResource.action();
        String onGranted = securedResource.onGranted();
        String onDenied = securedResource.onDenied();
        String declaringClass = metaMethod.getDeclaringClassName();
        int paramCount = metaMethod.getParameters().length;
        if (!metaMethod.getReturnType().getName().equals("void")) {
            throw new RuntimeException("The @ResourceCheck annotated method \"" + declaringClass + "#" + metaMethod.getName() + "\" must return void");
        }
        boolean resourceCheck = false;
        if (paramCount > 0) {
            MetaParameter resourceParameter = metaMethod.getParameters()[0];
            resourceCheck = this.implementsResource(resourceParameter.getType());
        }
        if (resourceCheck) {
            MetaParameter p1 = metaMethod.getParameters()[0];
            Statement stmt = this.createResourceActionCheck(p1.getName(), resourceAction, onGranted, onDenied);
            controller.addInvokeBefore(metaMethod, stmt);
        } else {
            if (resourceType == null || resourceType.trim().length() == 0) {
                throw new RuntimeException("The @ResourceCheck parameter named \"type\" is missing \"" + declaringClass + "#" + metaMethod.getName() + "\"");
            }
            Statement stmt = this.createGlobalActionCheck(resourceType, resourceAction, onGranted, onDenied);
            controller.addInvokeBefore(metaMethod, stmt);
        }
    }

    public boolean implementsResource(MetaClass metaClass) {
        for (MetaClass iface : metaClass.getInterfaces()) {
            if (!iface.asClass().equals(Resource.class) && !this.implementsResource(iface)) continue;
            return true;
        }
        return false;
    }

    public Statement createResourceActionCheck(String resourceName, String resourceAction, String onGranted, String onDenied) {
        return ResourceCheckProcessor.buildCheckStatement(Stmt.invokeStatic(AuthorizationManagerHelper.class, (String)"authorize", (Object[])new Object[]{Stmt.loadVariable((String)resourceName, (Object[])new Object[0]), resourceAction}), onGranted, onDenied);
    }

    public Statement createGlobalActionCheck(String resourceType, String resourceAction, String onGranted, String onDenied) {
        return ResourceCheckProcessor.buildCheckStatement(Stmt.invokeStatic(AuthorizationManagerHelper.class, (String)"authorize", (Object[])new Object[]{resourceType, resourceAction}), onGranted, onDenied);
    }

    public static Statement buildCheckStatement(ContextualStatementBuilder authzCall, String onGranted, String onDenied) {
        BooleanExpression boolExpr = BooleanExpressionBuilder.create((Statement)authzCall).negate();
        BlockBuilder builder = If.cond((BooleanExpression)boolExpr);
        if (onDenied != null && onDenied.trim().length() > 0) {
            builder.append((Statement)Stmt.loadVariable((String)"this", (Object[])new Object[0]).invoke(onDenied, new Object[0]));
        }
        BlockBuilder endBuilder = ((ElseBlockBuilder)builder.append((Statement)Stmt.returnVoid()).finish()).else_();
        if (onGranted != null && onGranted.trim().length() > 0) {
            endBuilder.append((Statement)Stmt.loadVariable((String)"this", (Object[])new Object[0]).invoke(onGranted, new Object[0]));
        }
        return (Statement)endBuilder.finish();
    }
}

