/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.client.editor.user;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.client.editor.Driver;
import org.uberfire.ext.security.management.client.editor.user.UserEditor;

@Dependent
public class UserEditorDriver
implements Driver<User, UserEditor> {
    ClientUserSystemManager userSystemManager;
    UserEditor userEditor;
    User user;
    boolean isFlushed = false;
    boolean isEditMode = false;

    @Inject
    public UserEditorDriver(ClientUserSystemManager userSystemManager) {
        this.userSystemManager = userSystemManager;
    }

    public User createNewUser(String identifier) {
        User user = this.userSystemManager.createUser(identifier);
        Collection<UserManager.UserAttribute> attrs = this.userSystemManager.getUserSupportedAttributes();
        if (attrs != null) {
            for (UserManager.UserAttribute attribute : attrs) {
                String name = attribute.getName();
                boolean isMandatory = attribute.isMandatory();
                boolean isEditable = attribute.isEditable();
                if (!isMandatory || !isEditable || name == null) continue;
                String defaultValue = attribute.getDefaultValue();
                user.setProperty(name, defaultValue);
            }
        }
        return user;
    }

    @Override
    public void show(User user, UserEditor userEditor) {
        this.isFlushed = false;
        this.isEditMode = false;
        this.user = user;
        this.userEditor = userEditor;
        userEditor.show(user);
        userEditor.attributesEditor().show(user);
        userEditor.groupsExplorer().show(user);
        userEditor.rolesExplorer().show(user);
    }

    @Override
    public void edit(User user, UserEditor userEditor) {
        this.isFlushed = false;
        this.isEditMode = true;
        this.user = user;
        this.userEditor = userEditor;
        userEditor.edit(user);
        userEditor.attributesEditor().edit(user);
        userEditor.groupsExplorer().edit(user);
        userEditor.rolesExplorer().edit(user);
    }

    @Override
    public boolean flush() {
        assert (this.isEditMode);
        this.isFlushed = true;
        this.userEditor.flush();
        this.userEditor.attributesEditor().flush();
        this.userEditor.groupsExplorer().flush();
        this.userEditor.rolesExplorer().flush();
        String id = this.userEditor.identifier();
        Map properties = (Map)this.userEditor.attributesEditor().getValue();
        Set groups = (Set)this.userEditor.groupsExplorer().getValue();
        Set roles = (Set)this.userEditor.rolesExplorer().getValue();
        this.user = new UserImpl(id, (Collection)roles, (Collection)groups, properties);
        Set violations = this.userSystemManager.usersValidator().validate((Object)this.user);
        this.userEditor.setViolations(violations);
        return violations == null || violations.isEmpty();
    }

    @Override
    public User getValue() {
        assert (this.isFlushed);
        return this.user;
    }
}

