/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.source;

import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.security.Role;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.auth.RoleProvider;
import org.uberfire.security.auth.RolesMode;
import org.uberfire.security.impl.RoleImpl;
import org.uberfire.security.impl.auth.UserNameCredential;
import org.uberfire.security.server.HttpSecurityContext;
import org.uberfire.security.server.RolesRegistry;
import org.uberfire.security.server.auth.source.adapter.RolesAdapter;

public class JACCAuthenticationSource
implements AuthenticationSource,
RoleProvider {
    public static final String DEFAULT_ROLE_PRINCIPLE_NAME = "Roles";
    private String rolePrincipleName = "Roles";
    private ServiceLoader<RolesAdapter> rolesAdapterServiceLoader = ServiceLoader.load(RolesAdapter.class);
    private RolesMode mode = RolesMode.GROUP;

    public void initialize(Map<String, ?> options) {
        if (options.containsKey("org.uf.context.roles")) {
            this.rolePrincipleName = (String)options.get("org.uf.context.roles");
        }
        try {
            if (options.containsKey("org.uberfire.roles.mode")) {
                this.mode = RolesMode.valueOf((String)((String)options.get("org.uberfire.roles.mode")));
            }
        }
        catch (Exception ignore) {
            this.mode = RolesMode.GROUP;
        }
    }

    public boolean supportsCredential(Credential credential) {
        return credential != null && credential instanceof UserNameCredential;
    }

    public boolean authenticate(Credential credential, SecurityContext securityContext) {
        UserNameCredential userNameCredential = (UserNameCredential)Preconditions.checkInstanceOf((String)"credential", (Object)credential, UserNameCredential.class);
        try {
            Set<java.security.Principal> principals;
            Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            if (subject != null && (principals = subject.getPrincipals()) != null) {
                for (java.security.Principal p : principals) {
                    if (!p.getName().equals(userNameCredential.getUserName())) continue;
                    return true;
                }
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return false;
    }

    public List<Role> loadRoles(Principal principal, SecurityContext securityContext) {
        ArrayList<Role> roles = new ArrayList<Role>();
        try {
            Subject subject = this.getSubjectFromContainer();
            if (subject != null) {
                if (this.mode.equals((Object)RolesMode.ROLE) || this.mode.equals((Object)RolesMode.BOTH)) {
                    roles.addAll(this.loadRoles(subject, securityContext));
                }
                if (this.mode.equals((Object)RolesMode.GROUP) || this.mode.equals((Object)RolesMode.BOTH)) {
                    roles.addAll(this.loadGroups(subject));
                }
            } else {
                for (RolesAdapter adapter : this.rolesAdapterServiceLoader) {
                    List<Role> userRoles = adapter.getRoles(principal, securityContext, this.mode);
                    if (userRoles == null) continue;
                    roles.addAll(userRoles);
                }
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return roles;
    }

    private List<Role> loadGroups(Subject subject) {
        ArrayList<Role> roles = new ArrayList<Role>();
        Set<java.security.Principal> principals = subject.getPrincipals();
        if (principals != null) {
            for (java.security.Principal p : principals) {
                if (!(p instanceof Group) || !this.rolePrincipleName.equalsIgnoreCase(p.getName())) continue;
                Enumeration groups = ((Group)p).members();
                while (groups.hasMoreElements()) {
                    java.security.Principal groupPrincipal = (java.security.Principal)groups.nextElement();
                    roles.add((Role)new RoleImpl(groupPrincipal.getName()));
                }
                break block0;
            }
        }
        return roles;
    }

    private List<Role> loadRoles(Subject subject, SecurityContext securityContext) {
        ArrayList<Role> roles = new ArrayList<Role>();
        if (securityContext instanceof HttpSecurityContext) {
            HttpServletRequest request = ((HttpSecurityContext)securityContext).getRequest();
            for (Role enforcementRole : RolesRegistry.get().getRegisteredRoles()) {
                if (!request.isUserInRole(enforcementRole.getName())) continue;
                roles.add((Role)new RoleImpl(enforcementRole.getName()));
            }
        }
        return roles;
    }

    protected Subject getSubjectFromContainer() {
        try {
            return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (Exception e) {
            return null;
        }
    }
}

