/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.source.adapter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.security.Role;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.auth.RolesMode;
import org.uberfire.security.impl.RoleImpl;
import org.uberfire.security.server.HttpSecurityContext;
import org.uberfire.security.server.RolesRegistry;
import org.uberfire.security.server.auth.source.adapter.RolesAdapter;
import org.uberfire.security.server.auth.source.adapter.WebSphereRoleProviderServices;

@ApplicationScoped
public class WeblogicRolesAdapter
implements RolesAdapter {
    @Inject
    private WebSphereRoleProviderServices roleProviderServices;
    private static final Logger logger = LoggerFactory.getLogger(WeblogicRolesAdapter.class);
    private Class webLogicSecurity;

    public WeblogicRolesAdapter() {
        try {
            this.webLogicSecurity = Class.forName("weblogic.security.Security");
        }
        catch (Exception e) {
            logger.warn("Unable to find weblogic.security.Security, disabling weblogic adapter");
        }
    }

    @Override
    public List<Role> getRoles(Principal principal, SecurityContext securityContext, RolesMode mode) {
        ArrayList<Role> roles = new ArrayList<Role>();
        if (this.webLogicSecurity == null) {
            return roles;
        }
        if (mode.equals((Object)RolesMode.GROUP) || mode.equals((Object)RolesMode.BOTH)) {
            try {
                Method method = this.webLogicSecurity.getMethod("getCurrentSubject", new Class[0]);
                Subject wlsSubject = (Subject)method.invoke(null, new Object[0]);
                if (wlsSubject != null) {
                    for (java.security.Principal p : wlsSubject.getPrincipals()) {
                        if (p.getClass().getName().indexOf("WLSGroup") == -1) continue;
                        roles.add((Role)new RoleImpl(p.getName()));
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to get groups from subject due to {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (mode.equals((Object)RolesMode.ROLE) || mode.equals((Object)RolesMode.BOTH)) {
            if (securityContext instanceof HttpSecurityContext) {
                HttpServletRequest request = ((HttpSecurityContext)securityContext).getRequest();
                for (Role enforcementRole : RolesRegistry.get().getRegisteredRoles()) {
                    if (!request.isUserInRole(enforcementRole.getName())) continue;
                    roles.add((Role)new RoleImpl(enforcementRole.getName()));
                }
            } else if (this.roleProviderServices != null) {
                roles.addAll(this.roleProviderServices.getRoles());
            }
        }
        return roles;
    }
}

