/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.backend.config.Added;
import org.guvnor.structure.backend.config.Removed;
import org.guvnor.structure.backend.deployment.DeploymentConfigChangedEvent;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.deployment.DeploymentConfig;
import org.guvnor.structure.deployment.DeploymentConfigService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.deployment.DeploymentConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DeploymentConfigServiceImpl
implements DeploymentConfigService {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentConfigServiceImpl.class);
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private DeploymentConfigFactory deploymentFactory;
    @Inject
    @Added
    private Event<DeploymentConfigChangedEvent> addedDeploymentEvent;
    @Inject
    @Removed
    private Event<DeploymentConfigChangedEvent> removedDeploymentEvent;
    private Map<String, DeploymentConfig> registeredDeployments = new ConcurrentHashMap<String, DeploymentConfig>();

    @PostConstruct
    public void loadGroups() {
        List deployments = this.configurationService.getConfiguration(ConfigType.DEPLOYMENT);
        if (deployments != null) {
            for (ConfigGroup deploymentConfig : deployments) {
                DeploymentConfig deployment = this.deploymentFactory.newDeployment(deploymentConfig);
                this.registeredDeployments.put(deployment.getIdentifier(), deployment);
            }
        }
    }

    public void addDeployment(String identifier, Object deploymentUnit) {
        ConfigGroup deploymentConfig = this.configurationFactory.newConfigGroup(ConfigType.DEPLOYMENT, identifier, "");
        deploymentConfig.addConfigItem(this.configurationFactory.newConfigItem("unit", deploymentUnit));
        this.configurationService.addConfiguration(deploymentConfig);
        DeploymentConfig deployment = this.deploymentFactory.newDeployment(deploymentConfig);
        this.registeredDeployments.put(deployment.getIdentifier(), deployment);
    }

    public void removeDeployment(String identifier) {
        ConfigGroup deploymentConfig = this.configurationFactory.newConfigGroup(ConfigType.DEPLOYMENT, identifier, "");
        this.configurationService.removeConfiguration(deploymentConfig);
        this.registeredDeployments.remove(identifier);
    }

    public DeploymentConfig getDeployment(String identifier) {
        return this.registeredDeployments.get(identifier);
    }

    public Collection<DeploymentConfig> getDeployments() {
        return Collections.unmodifiableCollection(this.registeredDeployments.values());
    }

    public void updateRegisteredDeployments(@Observes SystemRepositoryChangedEvent changedEvent) {
        logger.debug("Received deployment changed event, processing...");
        List deployments = this.configurationService.getConfiguration(ConfigType.DEPLOYMENT);
        if (deployments != null) {
            DeploymentConfig deployment;
            ArrayList<String> processedDeployments = new ArrayList<String>();
            for (ConfigGroup deploymentConfig : deployments) {
                String name = deploymentConfig.getName();
                if (!this.registeredDeployments.containsKey(name)) {
                    try {
                        logger.debug("New deployment {} has been discovered and will be deployed", (Object)name);
                        deployment = this.deploymentFactory.newDeployment(deploymentConfig);
                        this.addedDeploymentEvent.fire((Object)new DeploymentConfigChangedEvent(deployment.getDeploymentUnit()));
                        this.registeredDeployments.put(deployment.getIdentifier(), deployment);
                        logger.debug("Deployment {} deployed successfully", (Object)name);
                    }
                    catch (RuntimeException e) {
                        logger.warn("Deployment {} failed to deploy due to {}", new Object[]{name, e.getMessage(), e});
                    }
                }
                processedDeployments.add(name);
            }
            Set<String> registeredDeploymedIds = this.registeredDeployments.keySet();
            for (String identifier : registeredDeploymedIds) {
                if (processedDeployments.contains(identifier)) continue;
                try {
                    logger.debug("New deployment {} has been discovered and will be deployed", (Object)identifier);
                    deployment = this.registeredDeployments.remove(identifier);
                    this.removedDeploymentEvent.fire((Object)new DeploymentConfigChangedEvent(deployment.getDeploymentUnit()));
                    logger.debug("Deployment {} undeployed successfully", (Object)identifier);
                }
                catch (RuntimeException e) {
                    logger.warn("Undeployment {} failed to deploy due to {}", new Object[]{identifier, e.getMessage(), e});
                }
            }
        }
    }
}

