/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.RolePermissions;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Repository;
import org.uberfire.security.Contributor;

public class BranchAccessAuthorizer {
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    private ConfiguredRepositories configuredRepositories;
    private OrganizationalUnitService organizationalUnitService;

    public BranchAccessAuthorizer() {
    }

    @Inject
    public BranchAccessAuthorizer(SpaceConfigStorageRegistry spaceConfigStorageRegistry, ConfiguredRepositories configuredRepositories, OrganizationalUnitService organizationalUnitService) {
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
        this.configuredRepositories = configuredRepositories;
        this.organizationalUnitService = organizationalUnitService;
    }

    public boolean authorize(String user, String spaceName, String repositoryIdentifier, String repositoryAlias, String branchName, AccessType accessType) {
        BranchPermissions branchPermissions = this.spaceConfigStorageRegistry.get(spaceName).loadBranchPermissions(branchName, repositoryIdentifier);
        OrganizationalUnit organizationalUnit = this.organizationalUnitService.getOrganizationalUnit(spaceName);
        Repository repository = this.configuredRepositories.getRepositoryByRepositoryAlias(organizationalUnit.getSpace(), repositoryAlias);
        Optional<Contributor> userContributor = repository.getContributors().stream().filter(c -> c.getUsername().equals(user)).findFirst();
        if (userContributor.isPresent()) {
            String userRole = userContributor.get().getType().name();
            RolePermissions rolePermissions = (RolePermissions)branchPermissions.getPermissionsByRole().get(userRole);
            if (AccessType.READ.equals((Object)accessType)) {
                return rolePermissions.canRead();
            }
            if (AccessType.WRITE.equals((Object)accessType)) {
                return rolePermissions.canWrite();
            }
            if (AccessType.DELETE.equals((Object)accessType)) {
                return rolePermissions.canDelete();
            }
        }
        return true;
    }

    public static enum AccessType {
        READ,
        WRITE,
        DELETE;


        public static AccessType valueOf(ReceiveCommand.Type commandType) {
            if (commandType == null) {
                return null;
            }
            if (commandType.equals((Object)ReceiveCommand.Type.DELETE)) {
                return DELETE;
            }
            return WRITE;
        }
    }
}

