/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.guvnor.structure.client.editors.repository.common.CopyRepositoryUrlBtn;
import org.guvnor.structure.client.editors.repository.list.ProtocolButton;
import org.guvnor.structure.client.editors.repository.list.RepositoryItemPresenter;
import org.guvnor.structure.client.editors.repository.list.RepositoryItemView;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;

public class RepositoryItemViewImpl
extends Composite
implements RepositoryItemView {
    private static RepositoriesViewItemBinder uiBinder = (RepositoriesViewItemBinder)GWT.create(RepositoriesViewItemBinder.class);
    @UiField
    public Heading repoName;
    @UiField
    public Paragraph repoDesc;
    @UiField
    public TextBox gitDaemonURI;
    @UiField
    public CopyRepositoryUrlBtn myGitCopyButton;
    @UiField
    public Paragraph linksPanel;
    @UiField
    public Select branchesDropdown;
    @UiField
    public Button btnChangeBranch;
    private RepositoryItemPresenter presenter;

    @Inject
    public RepositoryItemViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.myGitCopyButton.addDomHandler((EventHandler)((ClickHandler)e -> this.presenter.onGitUrlCopied(this.gitDaemonURI.getText())), ClickEvent.getType());
        RepositoryItemViewImpl.glueCopy(this.myGitCopyButton.getElement());
    }

    public static native void glueCopy(Element var0);

    @Override
    public void setRepositoryName(String repositoryName) {
        this.repoName.setText(repositoryName);
    }

    @Override
    public void setRepositoryDescription(String description) {
        this.repoDesc.setText(description);
    }

    @Override
    public void showAvailableProtocols() {
        this.linksPanel.setText(CoreConstants.INSTANCE.AvailableProtocols());
    }

    @Override
    public void setDaemonURI(String uri) {
        this.gitDaemonURI.setText(uri);
    }

    @Override
    public void addProtocol(final String protocol) {
        this.linksPanel.add((Widget)new ProtocolButton(protocol, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RepositoryItemViewImpl.this.presenter.onAnchorSelected(protocol);
            }
        }, this.linksPanel.getWidgetCount() != 0));
    }

    @Override
    public void setPresenter(RepositoryItemPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setUriId(String uriId) {
        this.gitDaemonURI.getElement().setId(uriId);
        this.myGitCopyButton.init(true, uriId, this.gitDaemonURI.getText());
    }

    @Override
    public void clearBranches() {
        this.branchesDropdown.clear();
    }

    @Override
    public void addBranch(String branch) {
        Option option = new Option();
        option.setText(branch);
        option.setValue(branch);
        this.branchesDropdown.add((Widget)option);
    }

    @Override
    public void setSelectedBranch(String currentBranch) {
        this.branchesDropdown.setValue((Object)currentBranch);
        this.branchesDropdown.refresh();
    }

    @Override
    public String getSelectedBranch() {
        return this.branchesDropdown.getValue();
    }

    @Override
    public void refresh() {
        this.branchesDropdown.refresh();
    }

    @UiHandler(value={"btnChangeBranch"})
    public void onUpdateRepository(ClickEvent event) {
        this.presenter.onUpdateRepository(this.branchesDropdown.getValue());
    }

    static interface RepositoriesViewItemBinder
    extends UiBinder<Widget, RepositoryItemViewImpl> {
    }
}

