/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.tree;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.function.Supplier;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;

public class FSTreeItem
extends TreeItem<FSTreeItem> {
    private final FSType fstype;

    FSTreeItem(FSType type, String value, Supplier<FlowPanel> contentProvider) {
        super(FSTreeItem.createType(type), value, value, (IsWidget)FSTreeItem.createIcon(type), contentProvider);
        this.fstype = (FSType)((Object)PortablePreconditions.checkNotNull((String)"type", (Object)((Object)type)));
    }

    public FSTreeItem(FSType type, String value) {
        super(FSTreeItem.createType(type), value, value, (IsWidget)FSTreeItem.createIcon(type));
        this.fstype = (FSType)((Object)PortablePreconditions.checkNotNull((String)"type", (Object)((Object)type)));
    }

    private static final TreeItem.Type createType(FSType type) {
        switch (type) {
            case ITEM: {
                return TreeItem.Type.ITEM;
            }
            case FOLDER: {
                return TreeItem.Type.CONTAINER;
            }
        }
        return TreeItem.Type.ROOT;
    }

    private static final Icon createIcon(FSType type) {
        IconType iconType = IconType.FOLDER;
        switch (type) {
            case ITEM: {
                iconType = IconType.FILE_O;
                break;
            }
            case FOLDER: {
                iconType = IconType.FOLDER;
                break;
            }
            case ROOT: {
                iconType = IconType.FOLDER;
            }
        }
        return new Icon(iconType);
    }

    public FSTreeItem addItem(FSType type, String value) {
        FSTreeItem treeItem = new FSTreeItem(type, value);
        super.addItem(treeItem);
        return treeItem;
    }

    public FSType getFSType() {
        return this.fstype;
    }

    @Override
    protected void onOpenState() {
        super.onOpenState();
        this.getIcon().setType(IconType.FOLDER_OPEN);
    }

    @Override
    protected void onCloseState() {
        super.onCloseState();
        this.getIcon().setType(IconType.FOLDER);
    }

    private Icon getIcon() {
        return (Icon)this.getIconWidget();
    }

    public static enum FSType {
        ROOT,
        FOLDER,
        ITEM,
        LOADING;

    }
}

