/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.core.client.tree;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.function.Supplier;
import org.uberfire.ext.widgets.core.client.resources.TreeNavigatorResources;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;

public class Tree<T extends TreeItem>
extends Composite
implements HasSelectionHandlers<T>,
HasOpenHandlers<T>,
HasCloseHandlers<T> {
    private FlowPanel container;
    private T curSelection = null;

    public Tree() {
        this(FlowPanel::new);
    }

    Tree(Supplier<FlowPanel> containerProvider) {
        this.container = containerProvider.get();
        this.initWidget((Widget)this.container);
        this.container.setStylePrimaryName(TreeNavigatorResources.INSTANCE.css().tree());
    }

    public HandlerRegistration addOpenHandler(OpenHandler<T> handler) {
        return this.addHandler((EventHandler)handler, OpenEvent.getType());
    }

    public HandlerRegistration addCloseHandler(CloseHandler<T> handler) {
        return this.addHandler((EventHandler)handler, CloseEvent.getType());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<T> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public void clear() {
        this.container.clear();
    }

    public void setSelectedItem(T item, boolean fireEvents) {
        this.onSelection(item, fireEvents);
    }

    public T getSelectedItem() {
        return this.curSelection;
    }

    public void setSelectedItem(T item) {
        this.onSelection(item, true);
    }

    public T addItem(T item) {
        this.container.add(item);
        ((TreeItem)((Object)item)).setTree(this);
        return item;
    }

    public T getItem(int index) {
        TreeItem item = null;
        Iterator<T> itemIter = this.getItems().iterator();
        int idx = 0;
        while (itemIter.hasNext()) {
            TreeItem treeItem = (TreeItem)((Object)itemIter.next());
            if (idx == index) {
                item = treeItem;
                break;
            }
            ++idx;
        }
        return (T)((Object)item);
    }

    public void removeItem(T item) {
        this.container.remove(item);
    }

    public Iterable<T> getItems() {
        return () -> new TreeItem.TreeItemIterator((ComplexPanel)this.container);
    }

    public boolean isEmpty() {
        return this.container.getWidgetCount() == 0;
    }

    void onSelection(T item, boolean fireEvents) {
        if (this.curSelection != null) {
            ((TreeItem)((Object)this.curSelection)).setSelected(false);
        }
        this.curSelection = item;
        if (this.curSelection != null) {
            ((TreeItem)((Object)this.curSelection)).setSelected(true);
            if (fireEvents) {
                SelectionEvent.fire((HasSelectionHandlers)this, this.curSelection);
            }
        }
    }

    void fireStateChanged(T item, TreeItem.State state) {
        if (state.equals((Object)TreeItem.State.OPEN)) {
            OpenEvent.fire((HasOpenHandlers)this, item);
        } else {
            CloseEvent.fire((HasCloseHandlers)this, item);
        }
        this.onSelection(item, true);
    }
}

