/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.core.config.Configuration;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.core.util.ConfigUtils;
import org.unitils.database.DataSourceWrapper;
import org.unitils.database.annotations.TestDataSource;
import org.unitils.database.annotations.Transactional;
import org.unitils.database.config.DatabaseConfiguration;
import org.unitils.database.config.DatabaseConfigurations;
import org.unitils.database.config.DatabaseConfigurationsFactory;
import org.unitils.database.transaction.UnitilsTransactionManager;
import org.unitils.database.transaction.impl.UnitilsTransactionManagementConfiguration;
import org.unitils.database.util.Flushable;
import org.unitils.database.util.TransactionMode;
import org.unitils.dbmaintainer.DBMaintainer;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ModuleUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class DatabaseModule
implements Module {
    public static final String PROPERTY_UPDATEDATABASESCHEMA_ENABLED = "updateDataBaseSchema.enabled";
    public static final String PROPERTY_RESET_SEQUENCES = "reset.sequences.to.lowest.value.before.test";
    public static final String PROPERTY_WRAP_DATASOURCE_IN_TRANSACTIONAL_PROXY = "dataSource.wrapInTransactionalProxy";
    private static Log logger = LogFactory.getLog(DatabaseModule.class);
    protected Map<Class<? extends Annotation>, Map<String, String>> defaultAnnotationPropertyValues;
    protected DataSource dataSource;
    protected Properties configuration;
    protected boolean updateDatabaseSchemaEnabled;
    protected boolean wrapDataSourceInTransactionalProxy;
    protected UnitilsTransactionManager transactionManager;
    protected Set<UnitilsTransactionManagementConfiguration> transactionManagementConfigurations = new HashSet<UnitilsTransactionManagementConfiguration>();
    private DatabaseConfigurations databaseConfigurations;
    protected Map<String, DataSourceWrapper> wrappers = new HashMap<String, DataSourceWrapper>();

    public void init(Properties configuration) {
        this.configuration = configuration;
        DatabaseConfigurationsFactory configFactory = new DatabaseConfigurationsFactory(new Configuration(configuration));
        this.databaseConfigurations = configFactory.create();
        this.defaultAnnotationPropertyValues = ModuleUtils.getAnnotationPropertyDefaults(DatabaseModule.class, (Properties)configuration, (Class[])new Class[]{Transactional.class});
        this.updateDatabaseSchemaEnabled = PropertyUtils.getBoolean((String)PROPERTY_UPDATEDATABASESCHEMA_ENABLED, (Properties)configuration);
        this.wrapDataSourceInTransactionalProxy = PropertyUtils.getBoolean((String)PROPERTY_WRAP_DATASOURCE_IN_TRANSACTIONAL_PROXY, (Properties)configuration);
        PlatformTransactionManager.class.getName();
    }

    public void afterInit() {
    }

    public void registerTransactionManagementConfiguration() {
        for (DataSourceWrapper wrapper : this.wrappers.values()) {
            this.registerTransactionManagementConfiguration(wrapper);
        }
    }

    public void registerTransactionManagementConfiguration(final DataSourceWrapper wrapper) {
        this.registerTransactionManagementConfiguration(new UnitilsTransactionManagementConfiguration(){

            @Override
            public boolean isApplicableFor(Object testObject) {
                return true;
            }

            @Override
            public PlatformTransactionManager getSpringPlatformTransactionManager(Object testObject) {
                return new DataSourceTransactionManager(wrapper.getDataSourceAndActivateTransactionIfNeeded());
            }

            @Override
            public boolean isTransactionalResourceAvailable(Object testObject) {
                return wrapper.isDataSourceLoaded();
            }

            @Override
            public Integer getPreference() {
                return 1;
            }
        });
    }

    public void activateTransactionIfNeeded() {
        if (this.transactionManager != null) {
            this.transactionManager.activateTransactionIfNeeded(this.getTestObject());
        }
    }

    public UnitilsTransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = (UnitilsTransactionManager)ConfigUtils.getInstanceOf(UnitilsTransactionManager.class, (Properties)this.configuration, (String[])new String[0]);
        }
        this.transactionManager.init(this.transactionManagementConfigurations);
        return this.transactionManager;
    }

    public void flushDatabaseUpdates(Object testObject) {
        List flushables = Unitils.getInstance().getModulesRepository().getModulesOfType(Flushable.class);
        for (Flushable flushable : flushables) {
            flushable.flushDatabaseUpdates(testObject);
        }
    }

    public void resetDatabaseState(SQLHandler sqlHandler, DataSourceWrapper wrapper) {
        String schema = wrapper.databaseConfiguration.getDefaultSchemaName();
        if (!StringUtils.isEmpty((String)schema)) {
            DatabaseConfiguration databaseConfiguration = wrapper.getDatabaseConfiguration();
            DBMaintainer dbMaintainer = new DBMaintainer(this.configuration, sqlHandler, databaseConfiguration.getDialect(), databaseConfiguration.getSchemaNames());
            dbMaintainer.resetDatabaseState(schema, wrapper.getDatabaseConfiguration().isDefaultDatabase());
        } else {
            logger.debug((Object)"No schema found! The database is not reset!");
        }
    }

    public void injectDataSource(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestDataSource.class);
        Set methods = AnnotationUtils.getMethodsAnnotatedWith(testObject.getClass(), TestDataSource.class);
        HashMap<String, DataSource> mapDatasources = new HashMap<String, DataSource>();
        for (Map.Entry<String, DataSourceWrapper> wrapper : this.wrappers.entrySet()) {
            DataSource dataSource2 = this.getDataSource(wrapper.getKey(), mapDatasources, testObject);
            this.setFieldDataSource(wrapper.getKey(), dataSource2, testObject, fields, methods);
        }
    }

    protected void setFieldDataSource(String databaseName, DataSource dataSource, Object testObject, Set<Field> fields, Set<Method> methods) {
        String tempDatabaseName;
        TestDataSource annotation;
        if (fields.isEmpty() && methods.isEmpty()) {
            return;
        }
        for (Field field : fields) {
            annotation = field.getAnnotation(TestDataSource.class);
            String string = tempDatabaseName = StringUtils.isEmpty((String)annotation.value()) ? this.databaseConfigurations.getDatabaseConfiguration().getDatabaseName() : annotation.value();
            if (annotation == null || !tempDatabaseName.equals(databaseName)) continue;
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)dataSource);
        }
        for (Method method : methods) {
            annotation = method.getAnnotation(TestDataSource.class);
            String string = tempDatabaseName = StringUtils.isEmpty((String)annotation.value()) ? this.databaseConfigurations.getDatabaseConfiguration().getDatabaseName() : annotation.value();
            if (annotation == null || !tempDatabaseName.equals(databaseName)) continue;
            try {
                method.invoke(testObject, dataSource);
            }
            catch (IllegalAccessException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected DataSource getDataSource(String databaseName, Map<String, DataSource> mapDatasources, Object testObject) {
        DataSource datasource = null;
        if (mapDatasources.containsKey(databaseName)) {
            datasource = mapDatasources.get(databaseName);
        } else {
            DataSourceWrapper wrapper = this.getWrapper(databaseName);
            datasource = wrapper.getTransactionalDataSourceAndActivateTransactionIfNeeded(testObject);
            mapDatasources.put(databaseName, datasource);
        }
        return datasource;
    }

    protected TransactionMode getTransactionMode(Object testObject, Method testMethod) {
        TransactionMode transactionMode = (TransactionMode)((Object)AnnotationUtils.getMethodOrClassLevelAnnotationProperty(Transactional.class, (String)"value", (Object)((Object)TransactionMode.DEFAULT), (Method)testMethod, testObject.getClass()));
        transactionMode = (TransactionMode)ModuleUtils.getEnumValueReplaceDefault(Transactional.class, (String)"value", (Enum)transactionMode, this.defaultAnnotationPropertyValues);
        return transactionMode;
    }

    protected void startTransactionForTestMethod(Object testObject, Method testMethod) {
        if (this.isTransactionsEnabled(testObject, testMethod)) {
            this.startTransaction(testObject);
        }
    }

    protected void endTransactionForTestMethod(Object testObject, Method testMethod) {
        if (this.isTransactionsEnabled(testObject, testMethod)) {
            if (this.getTransactionMode(testObject, testMethod) == TransactionMode.COMMIT) {
                this.commitTransaction(testObject);
            } else if (this.getTransactionMode(testObject, testMethod) == TransactionMode.ROLLBACK) {
                this.rollbackTransaction(testObject);
            }
        }
    }

    public void startTransaction(Object testObject) {
        this.getTransactionManager().startTransaction(testObject);
    }

    public void commitTransaction(Object testObject) {
        this.flushDatabaseUpdates(testObject);
        UnitilsTransactionManager transactionManager2 = this.getTransactionManager();
        transactionManager2.activateTransactionIfNeeded(testObject);
        transactionManager2.commit(testObject);
    }

    public void rollbackTransaction(Object testObject) {
        this.flushDatabaseUpdates(testObject);
        UnitilsTransactionManager transactionManager2 = this.getTransactionManager();
        transactionManager2.activateTransactionIfNeeded(testObject);
        transactionManager2.rollback(testObject);
    }

    public boolean isTransactionsEnabled(Object testObject, Method testMethod) {
        TransactionMode transactionMode = this.getTransactionMode(testObject, testMethod);
        return transactionMode != TransactionMode.DISABLED;
    }

    public void registerTransactionManagementConfiguration(UnitilsTransactionManagementConfiguration transactionManagementConfiguration) {
        this.transactionManagementConfigurations.add(transactionManagementConfiguration);
    }

    protected Object getTestObject() {
        return Unitils.getInstance().getTestContext().getTestObject();
    }

    public TestListener getTestListener() {
        return new DatabaseTestListener();
    }

    public DataSourceWrapper getWrapper(String databaseName) {
        String tempDatabaseName;
        String string = tempDatabaseName = StringUtils.isEmpty((String)databaseName) ? this.databaseConfigurations.getDatabaseConfiguration().getDatabaseName() : databaseName;
        if (this.wrappers.containsKey(tempDatabaseName)) {
            return this.wrappers.get(tempDatabaseName);
        }
        DataSourceWrapper wrapper = null;
        wrapper = StringUtils.isEmpty((String)databaseName) ? new DataSourceWrapper(this.databaseConfigurations.getDatabaseConfiguration(), this.configuration, this.getTransactionManager()) : new DataSourceWrapper(this.databaseConfigurations.getDatabaseConfiguration(databaseName), this.configuration, this.getTransactionManager());
        this.setWrapper(wrapper);
        return wrapper;
    }

    public void setWrapper(DataSourceWrapper wrapper) {
        if (!this.wrappers.keySet().contains(wrapper.getDatabaseName())) {
            this.wrappers.put(wrapper.getDatabaseName(), wrapper);
            this.registerTransactionManagementConfiguration(wrapper);
            if (PropertyUtils.getBoolean((String)PROPERTY_RESET_SEQUENCES, (boolean)false, (Properties)this.configuration)) {
                wrapper.restartSequences();
            }
        }
    }

    public DatabaseConfigurations getDatabaseConfigurations() {
        return this.databaseConfigurations;
    }

    protected class DatabaseTestListener
    extends TestListener {
        protected DatabaseTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            List<String> databaseNames = DatabaseModule.this.databaseConfigurations.getDatabaseNames();
            if (!databaseNames.isEmpty()) {
                for (String databaseName : databaseNames) {
                    DataSourceWrapper wrapper = DatabaseModule.this.getWrapper(databaseName);
                    DatabaseModule.this.setWrapper(wrapper);
                }
            } else {
                DatabaseModule.this.getWrapper("");
            }
            try {
                DatabaseModule.this.injectDataSource(testObject);
            }
            catch (Exception e) {
                throw new UnitilsException(e.getMessage(), (Throwable)e);
            }
            DatabaseModule.this.startTransactionForTestMethod(testObject, testMethod);
        }

        public void afterTestTearDown(Object testObject, Method testMethod) {
            DatabaseModule.this.endTransactionForTestMethod(testObject, testMethod);
        }
    }
}

