/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.database.config;

import java.util.HashMap;
import java.util.List;
import org.unitils.core.Factory;
import org.unitils.core.config.Configuration;
import org.unitils.database.config.DatabaseConfiguration;
import org.unitils.database.config.DatabaseConfigurations;

public class DatabaseConfigurationsFactory
implements Factory<DatabaseConfigurations> {
    protected Configuration configuration;

    public DatabaseConfigurationsFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    public DatabaseConfigurations create() {
        DatabaseConfiguration defaultDatabaseConfiguration = null;
        HashMap<String, DatabaseConfiguration> databaseConfigurations = new HashMap<String, DatabaseConfiguration>(3);
        List databaseNames = this.configuration.getOptionalStringList("database.names", new String[0]);
        for (String databaseName : databaseNames) {
            boolean defaultDatabase = defaultDatabaseConfiguration == null;
            DatabaseConfiguration databaseConfiguration = this.createDatabaseConfiguration(databaseName, defaultDatabase);
            databaseConfigurations.put(databaseName, databaseConfiguration);
            if (!defaultDatabase) continue;
            defaultDatabaseConfiguration = databaseConfiguration;
        }
        if (defaultDatabaseConfiguration == null) {
            defaultDatabaseConfiguration = this.createDatabaseConfiguration(null, true);
        }
        return new DatabaseConfigurations(defaultDatabaseConfiguration, databaseConfigurations);
    }

    protected DatabaseConfiguration createDatabaseConfiguration(String databaseName, boolean defaultDatabase) {
        String defaultSchemaName;
        String[] stringArray;
        if (databaseName == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = databaseName;
        }
        String[] classifiers = stringArray;
        String driverClassName = this.configuration.getOptionalString("database.driverClassName", classifiers);
        String url = this.configuration.getOptionalString("database.url", classifiers);
        String userName = this.configuration.getOptionalString("database.userName", classifiers);
        String password = this.configuration.getOptionalString("database.password", classifiers);
        String dialect = this.configuration.getOptionalString("database.dialect", classifiers);
        List schemaNames = this.configuration.getOptionalStringList("database.schemaNames", classifiers);
        Boolean updateDisabled = this.configuration.getOptionalBoolean("database.updateDisabled", classifiers);
        String string = defaultSchemaName = schemaNames.isEmpty() ? null : (String)schemaNames.get(0);
        if (updateDisabled == null) {
            updateDisabled = false;
        }
        return new DatabaseConfiguration(databaseName, dialect, driverClassName, url, userName, password, defaultSchemaName, schemaNames, updateDisabled, defaultDatabase);
    }
}

