/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.version;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Version
implements Comparable<Version> {
    private List<Long> indexes = new ArrayList<Long>();

    public Version(List<Long> indexes) {
        this.indexes = indexes;
    }

    public Version(String indexString) {
        this.indexes = this.extractIndexes(indexString);
    }

    public List<Long> getIndexes() {
        return this.indexes;
    }

    public Long getScriptIndex() {
        if (this.indexes.isEmpty()) {
            return null;
        }
        return this.indexes.get(this.indexes.size() - 1);
    }

    public void setIndexes(List<Long> indexes) {
        this.indexes = indexes;
    }

    public String getIndexesString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Long index : this.indexes) {
            if (first) {
                first = false;
            } else {
                result.append('.');
            }
            if (index == null) {
                result.append('x');
                continue;
            }
            result.append(index);
        }
        return result.toString();
    }

    protected List<Long> extractIndexes(String indexString) {
        String[] parts;
        ArrayList<Long> result = new ArrayList<Long>();
        if (StringUtils.isEmpty((String)indexString)) {
            return result;
        }
        for (String part : parts = StringUtils.split((String)indexString, (char)'.')) {
            if ("x".equalsIgnoreCase(part)) {
                result.add(null);
                continue;
            }
            result.add(new Long(part));
        }
        return result;
    }

    public String toString() {
        return "indexes: " + this.getIndexesString();
    }

    @Override
    public int compareTo(Version otherVersion) {
        List<Long> otherIndexes = otherVersion.getIndexes();
        if (this.indexes.isEmpty()) {
            if (otherIndexes.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (otherIndexes.isEmpty()) {
            return 1;
        }
        Iterator<Long> thisIterator = this.indexes.iterator();
        Iterator<Long> otherIterator = otherIndexes.iterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            Long thisIndex = thisIterator.next();
            Long otherIndex = otherIterator.next();
            if (thisIndex != null && otherIndex != null) {
                if (thisIndex < otherIndex) {
                    return -1;
                }
                if (thisIndex <= otherIndex) continue;
                return 1;
            }
            if (thisIndex != null) {
                return -1;
            }
            if (otherIndex == null) continue;
            return 1;
        }
        if (!thisIterator.hasNext() && !otherIterator.hasNext()) {
            return 0;
        }
        if (thisIterator.hasNext()) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.indexes == null ? 0 : this.indexes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return !(this.indexes == null ? other.indexes != null : !this.indexes.equals(other.indexes));
    }
}

