/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.changes;

import java.util.Date;

public final class ChangeSet {
    private final String packageName;
    private final String version;
    private final Date date;
    private final String distribution;
    private final String urgency;
    private final String changedBy;
    private final String[] changes;

    public ChangeSet(String packageName, String version, Date date, String distribution, String urgency, String changedBy, String[] changes) {
        this.packageName = packageName;
        this.version = version;
        this.date = date;
        this.distribution = distribution;
        this.urgency = urgency;
        this.changedBy = changedBy;
        this.changes = changes;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getUrgency() {
        return this.urgency;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public String[] getChanges() {
        return this.changes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTitle()).append('\n');
        if (this.changes.length > 0) {
            sb.append("\n");
        }
        for (String change : this.changes) {
            sb.append("  * ").append(change).append('\n');
        }
        return sb.toString();
    }

    private String getTitle() {
        return this.getPackage() + " (" + this.getVersion() + ") " + this.getDistribution() + "; urgency=" + this.getUrgency();
    }
}

