/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.math.ec.custom.sec;

import java.math.BigInteger;
import org.vafer.jdeb.shaded.bc.math.ec.ECCurve;
import org.vafer.jdeb.shaded.bc.math.ec.ECFieldElement;
import org.vafer.jdeb.shaded.bc.math.ec.ECLookupTable;
import org.vafer.jdeb.shaded.bc.math.ec.ECPoint;
import org.vafer.jdeb.shaded.bc.math.ec.custom.sec.SecP128R1FieldElement;
import org.vafer.jdeb.shaded.bc.math.ec.custom.sec.SecP128R1Point;
import org.vafer.jdeb.shaded.bc.math.raw.Nat128;
import org.vafer.jdeb.shaded.bc.util.encoders.Hex;

public class SecP128R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFF"));
    private static final int SecP128R1_DEFAULT_COORDS = 2;
    protected SecP128R1Point infinity = new SecP128R1Point(this, null, null);

    public SecP128R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("E87579C11079F43DD824993C2CEE5ED3")));
        this.order = new BigInteger(1, Hex.decode("FFFFFFFE0000000075A30D1B9038A115"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP128R1Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP128R1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
        return new SecP128R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
        return new SecP128R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int[] nArray = new int[n2 * 4 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat128.copy(((SecP128R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat128.copy(((SecP128R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 4);
            n3 += 4;
        }
        return new ECLookupTable(){

            public int getSize() {
                return n2;
            }

            public ECPoint lookup(int n) {
                int[] nArray3 = Nat128.create();
                int[] nArray2 = Nat128.create();
                int n22 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n3 = (i ^ n) - 1 >> 31;
                    for (int j = 0; j < 4; ++j) {
                        int n4 = j;
                        nArray3[n4] = nArray3[n4] ^ nArray[n22 + j] & n3;
                        int n5 = j;
                        nArray2[n5] = nArray2[n5] ^ nArray[n22 + 4 + j] & n3;
                    }
                    n22 += 8;
                }
                return SecP128R1Curve.this.createRawPoint(new SecP128R1FieldElement(nArray3), new SecP128R1FieldElement(nArray2), false);
            }
        };
    }
}

