/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.jsonpath;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.ReadContext;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class WithoutJsonPath
extends TypeSafeDiagnosingMatcher<ReadContext> {
    private final JsonPath jsonPath;

    public WithoutJsonPath(JsonPath jsonPath) {
        this.jsonPath = jsonPath;
    }

    protected boolean matchesSafely(ReadContext readContext, Description description) {
        try {
            Object object = readContext.read(this.jsonPath);
            description.appendText(this.jsonPath.getPath()).appendText(" was evaluated to ").appendValue(object);
            return object == null || Matchers.empty().matches(object);
        }
        catch (JsonPathException jsonPathException) {
            return true;
        }
    }

    public void describeTo(Description description) {
        description.appendText("without json path ").appendValue((Object)this.jsonPath.getPath());
    }
}

