/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.fonts;

import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.pd.font.GFPDEmptyFont;
import org.verapdf.gf.model.impl.pd.font.GFPDTrueTypeFont;
import org.verapdf.gf.model.impl.pd.font.GFPDType0Font;
import org.verapdf.gf.model.impl.pd.font.GFPDType1Font;
import org.verapdf.gf.model.impl.pd.font.GFPDType3Font;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.gf.model.tools.GFIDGenerator;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDType0Font;
import org.verapdf.pd.font.truetype.PDTrueTypeFont;
import org.verapdf.pd.font.type1.PDType1Font;
import org.verapdf.pd.font.type3.PDType3Font;

public class FontFactory {
    public static final String TYPE_0 = "Type0";
    public static final String TYPE_1 = "Type1";
    public static final String MM_TYPE_1 = "MMType1";
    public static final String TYPE_3 = "Type3";
    public static final String TRUE_TYPE = "TrueType";
    public static final String CID_FONT_TYPE_2 = "CIDFontType2";

    private FontFactory() {
    }

    public static org.verapdf.model.pdlayer.PDFont parseFont(PDFont rawFont, RenderingMode renderingMode, PDResourcesHandler resources, GraphicState inheritedGraphicState) {
        if (rawFont == null) {
            return new GFPDEmptyFont();
        }
        if (TYPE_3.equals(rawFont.getSubtype().getValue())) {
            PDResources fontResources = ((PDType3Font)rawFont).getResources();
            PDResourcesHandler pdResources = resources.getExtendedResources(fontResources);
            return new GFPDType3Font((PDType3Font)rawFont, renderingMode, pdResources, inheritedGraphicState);
        }
        String id = GFIDGenerator.generateID(rawFont, renderingMode);
        org.verapdf.model.pdlayer.PDFont res = StaticContainers.getCachedFonts().get(id);
        if (res == null) {
            switch (rawFont.getSubtype().getValue()) {
                case "Type0": {
                    res = new GFPDType0Font((PDType0Font)rawFont, renderingMode);
                    break;
                }
                case "Type1": 
                case "MMType1": {
                    res = new GFPDType1Font((PDType1Font)rawFont, renderingMode);
                    break;
                }
                case "TrueType": {
                    res = new GFPDTrueTypeFont((PDTrueTypeFont)rawFont, renderingMode);
                    break;
                }
                default: {
                    res = null;
                }
            }
            StaticContainers.getCachedFonts().put(id, res);
        }
        return res;
    }
}

