/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.cos.GFCosBBox;
import org.verapdf.gf.model.impl.pd.GFPDAnnot;
import org.verapdf.gf.model.impl.pd.GFPDContentStream;
import org.verapdf.gf.model.impl.pd.GFPDGroup;
import org.verapdf.gf.model.impl.pd.GFPDObject;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.pdlayer.PDPage;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDGroup;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.actions.PDAction;
import org.verapdf.pd.actions.PDPageAdditionalActions;
import org.verapdf.pd.structure.StructureElementAccessObject;

public class GFPDPage
extends GFPDObject
implements PDPage {
    public static final String PD_PAGE_TYPE = "PDPage";
    private static final String ANNOTS = "annots";
    private static final String ACTION = "AA";
    private static final String CONTENT_STREAM = "contentStream";
    private static final String GROUP = "Group";
    private static final String MEDIA_BOX = "MediaBox";
    private static final String CROP_BOX = "CropBox";
    private static final String BLEED_BOX = "BleedBox";
    private static final String TRIM_BOX = "TrimBox";
    private static final String ART_BOX = "ArtBox";
    public static final int MAX_NUMBER_OF_ACTIONS = 2;
    private boolean containsTransparency = false;
    private List<PDContentStream> contentStreams = null;
    private List<PDAnnot> annotations = null;

    public GFPDPage(org.verapdf.pd.PDPage pdPage) {
        super((PDObject)pdPage, PD_PAGE_TYPE);
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Group": {
                return this.getGroup();
            }
            case "annots": {
                return this.getAnnotations();
            }
            case "AA": {
                return this.getActions();
            }
            case "contentStream": {
                return this.getContentStream();
            }
            case "MediaBox": {
                return this.getMediaBox();
            }
            case "CropBox": {
                return this.getCropBox();
            }
            case "BleedBox": {
                return this.getBleedBox();
            }
            case "TrimBox": {
                return this.getTrimBox();
            }
            case "ArtBox": {
                return this.getArtBox();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDGroup> getGroup() {
        org.verapdf.pd.PDPage page = (org.verapdf.pd.PDPage)this.simplePDObject;
        PDGroup group = page.getGroup();
        if (group != null) {
            ArrayList<GFPDGroup> res = new ArrayList<GFPDGroup>(1);
            PDResourcesHandler resourcesHandler = PDResourcesHandler.getInstance(page.getResources(), page.isInheritedResources());
            res.add(new GFPDGroup(group, resourcesHandler.getPageResources()));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<PDAnnot> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.parseAnnotataions();
        }
        return this.annotations;
    }

    private List<PDAnnot> parseAnnotataions() {
        StaticContainers.getTransparencyVisitedContentStreams().clear();
        List annots = ((org.verapdf.pd.PDPage)this.simplePDObject).getAnnotations();
        if (annots.size() > 0) {
            ArrayList<GFPDAnnot> res = new ArrayList<GFPDAnnot>(annots.size());
            for (PDAnnotation annot : annots) {
                org.verapdf.pd.PDPage page = (org.verapdf.pd.PDPage)this.simplePDObject;
                PDResourcesHandler resourcesHandler = PDResourcesHandler.getInstance(page.getResources(), page.isInheritedResources());
                GFPDAnnot annotation = new GFPDAnnot(annot, resourcesHandler);
                this.containsTransparency |= annotation.isContainsTransparency();
                res.add(annotation);
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDAction> getActions() {
        PDPageAdditionalActions additionalActions = ((org.verapdf.pd.PDPage)this.simplePDObject).getAdditionalActions();
        if (additionalActions != null) {
            ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(2);
            PDAction raw = additionalActions.getC();
            this.addAction(actions, raw);
            raw = additionalActions.getO();
            this.addAction(actions, raw);
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private List<PDContentStream> getContentStream() {
        if (this.contentStreams == null) {
            this.contentStreams = this.parseContentStream();
        }
        return this.contentStreams;
    }

    private List<PDContentStream> parseContentStream() {
        StaticContainers.getTransparencyVisitedContentStreams().clear();
        ArrayList<PDContentStream> pdContentStreams = new ArrayList<PDContentStream>(1);
        org.verapdf.pd.PDPage page = (org.verapdf.pd.PDPage)this.simplePDObject;
        if (page.getContent() != null) {
            PDResourcesHandler resourcesHandler = PDResourcesHandler.getInstance(page.getResources(), page.isInheritedResources());
            GFPDContentStream pdContentStream = new GFPDContentStream(page.getContent(), resourcesHandler, null, new StructureElementAccessObject(this.simpleCOSObject));
            this.containsTransparency |= pdContentStream.isContainsTransparency();
            pdContentStreams.add(pdContentStream);
        }
        return pdContentStreams;
    }

    private List<CosBBox> getMediaBox() {
        return GFPDPage.getBBox(((org.verapdf.pd.PDPage)this.simplePDObject).getCOSMediaBox());
    }

    private List<CosBBox> getCropBox() {
        return GFPDPage.getBBox(((org.verapdf.pd.PDPage)this.simplePDObject).getCOSCropBox());
    }

    private List<CosBBox> getBleedBox() {
        return GFPDPage.getBBox(((org.verapdf.pd.PDPage)this.simplePDObject).getCOSBleedBox());
    }

    private List<CosBBox> getTrimBox() {
        return GFPDPage.getBBox(((org.verapdf.pd.PDPage)this.simplePDObject).getCOSTrimBox());
    }

    private List<CosBBox> getArtBox() {
        return GFPDPage.getBBox(((org.verapdf.pd.PDPage)this.simplePDObject).getCOSArtBox());
    }

    private static List<CosBBox> getBBox(COSArray array) {
        if (array != null) {
            ArrayList<GFCosBBox> res = new ArrayList<GFCosBBox>(1);
            res.add(new GFCosBBox(array));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsPresSteps() {
        return ((org.verapdf.pd.PDPage)this.simplePDObject).getCOSPresSteps() != null;
    }

    public Boolean getcontainsTransparency() {
        if (this.contentStreams == null) {
            this.contentStreams = this.parseContentStream();
        }
        if (this.annotations == null) {
            this.annotations = this.parseAnnotataions();
        }
        return this.containsTransparency;
    }

    public Boolean getcontainsGroupCS() {
        PDGroup group = ((org.verapdf.pd.PDPage)this.simplePDObject).getGroup();
        return group != null && group.getColorSpace() != null;
    }

    public Boolean getcontainsAA() {
        return this.simplePDObject == null ? Boolean.valueOf(false).booleanValue() : this.simplePDObject.knownKey(ASAtom.AA);
    }
}

