/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.actions;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.actions.Action;
import org.walkmod.javalang.actions.ActionType;
import org.walkmod.javalang.actions.AppendAction;
import org.walkmod.javalang.actions.RemoveAction;
import org.walkmod.javalang.actions.ReplaceAction;
import org.walkmod.javalang.util.FileUtils;

public class ActionsApplier {
    private String text;
    private List<Action> actions;
    private StringBuffer modifiedText;
    private Character indentationChar = null;
    private boolean annotationsInNewLines = false;

    public boolean isAnnotationsInNewLines() {
        return this.annotationsInNewLines;
    }

    public void setAnnotationsInNewLines(boolean annotationsInNewLines) {
        this.annotationsInNewLines = annotationsInNewLines;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setText(File file) {
        try {
            this.text = FileUtils.fileToString(file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading the file " + file.getAbsolutePath());
        }
    }

    public void setActionList(List<Action> actions) {
        this.actions = actions;
    }

    public String getModifiedText() {
        return this.modifiedText.toString();
    }

    public Character getIndentationChar() {
        return this.indentationChar;
    }

    public void inferIndentationChar(char[] contents) {
        if (this.indentationChar == null) {
            this.indentationChar = this.getIndentationChar(contents, '\n');
            if (this.indentationChar == null) {
                this.indentationChar = this.getIndentationChar(contents, '{');
                if (this.indentationChar == null) {
                    this.indentationChar = Character.valueOf('\u0000');
                }
            }
        }
    }

    private Character getIndentationChar(char[] contents, char separator) {
        int spaces = 0;
        int tabs = 0;
        boolean containsSeparator = false;
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] != separator) continue;
            containsSeparator = true;
            if (i + 1 >= contents.length) continue;
            if (contents[i + 1] == ' ') {
                ++spaces;
                continue;
            }
            if (contents[i + 1] != '\t') continue;
            ++tabs;
        }
        if (tabs > spaces) {
            return Character.valueOf('\t');
        }
        if (!containsSeparator) {
            return null;
        }
        if (spaces == 0 && spaces == tabs) {
            return Character.valueOf('\u0000');
        }
        return Character.valueOf(' ');
    }

    public void execute() {
        this.modifiedText = new StringBuffer();
        if (this.actions != null && this.text != null) {
            Iterator<Action> it = this.actions.iterator();
            char[] contents = this.text.toCharArray();
            int index = 0;
            int line = 0;
            int actionColumn = 0;
            Action previousAction = null;
            StringBuffer accum = null;
            StringBuffer indentation = new StringBuffer();
            while (it.hasNext()) {
                Action next = it.next();
                int actionLine = next.getBeginLine() - 1;
                if (previousAction != null && previousAction.getType().equals((Object)ActionType.REMOVE) && next.getType().equals((Object)ActionType.APPEND)) {
                    accum = this.modifiedText;
                    this.modifiedText = new StringBuffer();
                }
                for (int i = line; i < actionLine; ++i) {
                    boolean endLine = false;
                    while (index < contents.length && !endLine) {
                        endLine = contents[index] == '\n';
                        this.modifiedText.append(contents[index]);
                        ++index;
                        if (!endLine) continue;
                        ++line;
                        actionColumn = 0;
                        if (indentation.length() == 0) continue;
                        indentation = new StringBuffer();
                    }
                }
                if (index < contents.length) {
                    String code;
                    int incr = next.getBeginColumn() - 1 - actionColumn;
                    boolean stop = false;
                    if (incr > 0) {
                        for (int i = index; i < index + incr; ++i) {
                            if (!(stop || contents[i] != ' ' && contents[i] != '\t')) {
                                indentation.append(contents[i]);
                            } else {
                                stop = true;
                            }
                            this.modifiedText.append(contents[i]);
                            ++actionColumn;
                        }
                        index += incr;
                    }
                    if (previousAction != null && previousAction.getType().equals((Object)ActionType.REMOVE) && next.getType().equals((Object)ActionType.APPEND)) {
                        if (this.modifiedText.toString().trim().length() != 0) {
                            accum.append(this.modifiedText);
                        }
                        this.modifiedText = accum;
                    }
                    if (next.getType().equals((Object)ActionType.REMOVE)) {
                        boolean nextIsNewLine;
                        RemoveAction remove = (RemoveAction)next;
                        int lastLine = this.modifiedText.lastIndexOf("\n");
                        String aux = this.modifiedText.substring(lastLine + 1);
                        while (actionLine < remove.getEndLine() - 1 || actionLine == remove.getEndLine() - 1 && actionColumn < remove.getEndColumn()) {
                            if (contents[index] == '\r') {
                                ++actionColumn;
                            } else if (contents[index] != '\n') {
                                ++actionColumn;
                            } else {
                                ++actionLine;
                                ++line;
                                actionColumn = 0;
                            }
                            ++index;
                        }
                        if (index < contents.length && contents[index] == '\r') {
                            ++index;
                            ++actionColumn;
                        }
                        boolean bl = nextIsNewLine = index < contents.length && contents[index] == '\n';
                        if (nextIsNewLine) {
                            ++index;
                            ++line;
                            actionColumn = 0;
                            if (remove.getBeginColumn() > 1) {
                                int k;
                                LinkedList<Character> chars = new LinkedList<Character>();
                                while (index < contents.length && (contents[index] == ' ' || contents[index] == '\t')) {
                                    chars.add(Character.valueOf(contents[index]));
                                    ++actionColumn;
                                    ++index;
                                }
                                if (actionColumn + 1 > 1 && actionColumn + 1 < remove.getBeginColumn()) {
                                    if (aux.matches("\\s+") || aux.equals("")) {
                                        if (!"".equals(aux)) {
                                            this.modifiedText = this.modifiedText.delete(lastLine + 1, this.modifiedText.length());
                                        }
                                    } else {
                                        this.modifiedText.append('\n');
                                    }
                                    for (k = 0; k < actionColumn; ++k) {
                                        this.modifiedText.append(chars.get(k));
                                    }
                                } else if (actionColumn + 1 > remove.getBeginColumn()) {
                                    for (k = remove.getBeginColumn(); k < actionColumn + 1; ++k) {
                                        this.modifiedText.append(chars.get(k - remove.getBeginColumn()));
                                    }
                                } else if (actionColumn == 0 && (aux.matches("\\s+") || "".equals(aux))) {
                                    this.modifiedText = this.modifiedText.delete(lastLine + 1, this.modifiedText.length());
                                }
                            }
                        }
                    } else if (next.getType().equals((Object)ActionType.APPEND)) {
                        this.inferIndentationChar(contents);
                        AppendAction append = (AppendAction)next;
                        char indent = this.indentationChar.charValue();
                        if (indentation.length() > 1) {
                            indent = indentation.charAt(indentation.length() - 1);
                        }
                        code = append.getText(indentation.toString(), indent);
                        this.modifiedText.append(code);
                    } else if (next.getType().equals((Object)ActionType.REPLACE)) {
                        this.inferIndentationChar(contents);
                        char indent = this.indentationChar.charValue();
                        if (indentation.length() > 1) {
                            indent = indentation.charAt(indentation.length() - 1);
                        }
                        ReplaceAction replace = (ReplaceAction)next;
                        code = replace.getText(indentation.toString(), indent);
                        this.modifiedText.append(code);
                        int futureLine = replace.getOldEndLine() - 1;
                        while (actionLine < futureLine && index < contents.length) {
                            if (contents[index] == '\r' || contents[index] != '\n') {
                                ++actionColumn;
                            } else {
                                ++actionLine;
                                actionColumn = 0;
                            }
                            ++index;
                        }
                        line = futureLine;
                        index += replace.getOldEndColumn() - actionColumn;
                        actionColumn = replace.getOldEndColumn();
                    }
                }
                previousAction = next;
            }
            for (int i = index; i < contents.length; ++i) {
                this.modifiedText.append(contents[i]);
            }
        }
    }
}

