/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.actions;

import org.walkmod.javalang.actions.Action;
import org.walkmod.javalang.actions.ActionType;
import org.walkmod.javalang.actions.FormatterHelper;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.BlockStmt;

public class AppendAction
extends Action {
    private Node node;
    private int endLine = -1;
    private int endColumn = -1;
    private int indentationLevel = 0;
    private int indentationSize = 0;
    private int beginPosition = 0;
    private char indentationChar = (char)32;
    private String text = null;
    private int diff = 0;
    private int endLines = 0;

    public AppendAction(int beginLine, int beginPosition, Node node, int level, int indentationSize) {
        this(beginLine, beginPosition, node, level, indentationSize, 0);
    }

    public AppendAction(int beginLine, int beginPosition, Node node, int level, int indentationSize, int endLines) {
        super(beginLine, beginPosition, ActionType.APPEND);
        this.indentationLevel = level;
        this.indentationSize = indentationSize;
        this.node = node;
        this.beginPosition = beginPosition;
        this.endLines = endLines;
        if (beginPosition > 1 && indentationSize > 0) {
            this.diff = (beginPosition - 1) / indentationSize;
            this.indentationLevel -= this.diff;
        }
        this.getText("", this.indentationChar);
        String[] lines = this.text.split("\n");
        this.endLine = this.getBeginLine() + lines.length - 1;
        this.endColumn = this.endLine == beginLine ? this.getBeginColumn() + lines[lines.length - 1].length() : lines[lines.length - 1].length();
    }

    public int getEndLines() {
        return this.endLines;
    }

    public String getText(String indentation, char indentationChar) {
        this.indentationChar = indentationChar;
        this.text = this.node.getPrettySource(indentationChar, this.indentationLevel, this.indentationSize);
        if (this.endLines > 0 && !this.text.endsWith("\n")) {
            if (this.text.endsWith(" ")) {
                this.text = this.text.substring(0, this.text.length() - 1);
            }
            this.text = this.text + "\n";
        }
        String[] lines = this.text.split("\n");
        if (this.beginPosition > 1 && this.indentationSize > 0) {
            int i;
            if (lines.length > 1) {
                StringBuffer aux = new StringBuffer();
                aux.append(FormatterHelper.indent(this.text, indentation, indentationChar, this.indentationLevel, this.indentationSize, this.requiresExtraIndentationOnFirstLine(this.node)));
                for (i = 1; i < this.endLines; ++i) {
                    aux.append('\n');
                }
                this.text = aux.toString();
            }
            if (indentation.length() > 0) {
                this.text = this.text + indentation;
            } else {
                StringBuffer extraString = new StringBuffer("");
                for (i = 0; i < this.diff * this.indentationSize; ++i) {
                    extraString.append(indentationChar);
                }
                this.text = this.text + extraString;
            }
        }
        return this.text;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    public int getIndentations() {
        return this.indentationSize;
    }

    private boolean requiresExtraIndentationOnFirstLine(Node node) {
        return !(node instanceof Expression) && !(node instanceof BlockStmt);
    }
}

