/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.actions;

import org.walkmod.javalang.actions.Action;
import org.walkmod.javalang.actions.ActionType;
import org.walkmod.javalang.ast.LineComment;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.TypeDeclaration;

public class RemoveAction
extends Action {
    private int endLine;
    private int endColumn;
    private String text;

    public RemoveAction(int beginLine, int beginPosition, int endLine, int endColumn, Node node) {
        super(beginLine, beginPosition, ActionType.REMOVE);
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.text = node.toString();
        if (this.text.endsWith("\n") && node instanceof LineComment) {
            this.text = this.text.substring(0, this.text.length() - 1);
            --this.endColumn;
        } else if (this.text.endsWith("}") && node instanceof TypeDeclaration) {
            ++this.endColumn;
        }
    }

    public String getText() {
        return this.text;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }
}

