/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.actions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.actions.Action;
import org.walkmod.javalang.actions.ActionType;
import org.walkmod.javalang.actions.FormatterHelper;
import org.walkmod.javalang.ast.Comment;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.BlockStmt;

public class ReplaceAction
extends Action {
    private String newCode;
    private int endLine;
    private int endColumn;
    private String oldCode;
    private char indentationChar = (char)32;
    private int indentationLevel;
    private int indentationSize;
    private Node newNode;
    private Node oldNode;
    private List<Comment> acceptedComments = new LinkedList<Comment>();

    public ReplaceAction(int beginLine, int beginPosition, Node oldNode, Node newNode, int indentation, int indentationSize, List<Comment> comments) {
        super(beginLine, beginPosition, ActionType.REPLACE);
        if (comments != null) {
            Iterator<Comment> it = comments.iterator();
            while (it.hasNext()) {
                Comment next = it.next();
                if (!oldNode.contains(next) || next instanceof JavadocComment) continue;
                this.acceptedComments.add(next);
                it.remove();
            }
        }
        this.oldNode = oldNode;
        this.indentationLevel = indentation;
        this.oldCode = oldNode.getPrettySource(this.indentationChar, this.indentationLevel, indentationSize, this.acceptedComments);
        this.indentationSize = indentationSize;
        this.newNode = newNode;
        this.getText("", this.indentationChar);
        String[] lines = this.newCode.split("\n");
        this.endLine = this.getBeginLine() + lines.length - 1;
        this.endColumn = lines[lines.length - 1].length();
        if (oldNode.getEndLine() >= this.endLine) {
            if (oldNode.getEndLine() == this.endLine) {
                if (oldNode.getEndColumn() > this.endColumn) {
                    this.endLine = oldNode.getEndLine();
                    this.endColumn = oldNode.getEndColumn();
                }
            } else {
                this.endLine = oldNode.getEndLine();
                this.endColumn = oldNode.getEndColumn();
            }
        }
    }

    public String getText(String indentation, char indentationChar) {
        this.newCode = FormatterHelper.indent(this.newNode.getPrettySource(indentationChar, this.indentationLevel, this.indentationSize, this.acceptedComments), indentation, indentationChar, this.indentationLevel, this.indentationSize, this.requiresExtraIndentationOnFirstLine());
        return this.newCode;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public int getOldEndLine() {
        return this.oldNode.getEndLine();
    }

    public int getOldEndColumn() {
        return this.oldNode.getEndColumn();
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    public String getNewText() {
        return this.newCode;
    }

    public String getOldText() {
        return this.oldCode;
    }

    private boolean requiresExtraIndentationOnFirstLine() {
        if (this.newNode.getClass().getName().equals(this.oldNode.getClass().getName())) {
            return false;
        }
        return !(this.newNode instanceof Expression) && !(this.newNode instanceof BlockStmt) && !(this.newNode instanceof BodyDeclaration);
    }
}

