/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolDataAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.TypeDeclaration;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.comparators.ImportDeclarationComparator;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.Mergeable;

public final class ImportDeclaration
extends Node
implements Mergeable<ImportDeclaration>,
SymbolDefinition {
    private NameExpr name;
    private boolean static_;
    private boolean asterisk;
    private List<SymbolReference> usages;

    public ImportDeclaration() {
    }

    public ImportDeclaration(NameExpr name, boolean isStatic, boolean isAsterisk) {
        this.setName(name);
        this.static_ = isStatic;
        this.asterisk = isAsterisk;
    }

    public ImportDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, NameExpr name, boolean isStatic, boolean isAsterisk) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setName(name);
        this.static_ = isStatic;
        this.asterisk = isAsterisk;
    }

    @Override
    public boolean removeChild(Node child) {
        if (child == this.name && child != null) {
            this.name = null;
            this.updateReferences(child);
            return true;
        }
        return false;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> aux = new LinkedList<Node>();
        if (this.name != null) {
            aux.add(this.name);
        }
        return aux;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public NameExpr getName() {
        return this.name;
    }

    public boolean isAsterisk() {
        return this.asterisk;
    }

    public boolean isStatic() {
        return this.static_;
    }

    public void setAsterisk(boolean asterisk) {
        this.asterisk = asterisk;
    }

    public void setName(NameExpr name) {
        if (this.name != null) {
            this.updateReferences(this.name);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
    }

    public void setStatic(boolean static_) {
        this.static_ = static_;
    }

    public Comparator<?> getIdentityComparator() {
        return new ImportDeclarationComparator();
    }

    public void merge(ImportDeclaration t1, MergeEngine configuration) {
        if (t1.isStatic()) {
            this.setStatic(t1.isAsterisk());
        }
        if (t1.isAsterisk()) {
            this.setAsterisk(t1.isAsterisk());
        }
    }

    @Override
    public List<SymbolReference> getUsages() {
        return this.usages;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
        this.usages = usages;
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        return null;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
    }

    @Override
    public int getScopeLevel() {
        return 0;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        return false;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        if (usage != null) {
            usage.setSymbolDefinition(this);
            if (this.usages == null) {
                this.usages = new LinkedList<SymbolReference>();
            }
            return this.usages.add(usage);
        }
        return false;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        if (oldChild == this.name) {
            this.setName((NameExpr)newChild);
            return true;
        }
        return false;
    }

    @Override
    public ImportDeclaration clone() throws CloneNotSupportedException {
        return new ImportDeclaration(this.clone(this.name), this.static_, this.asterisk);
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        HashMap<String, SymbolDefinition> result = new HashMap<String, SymbolDefinition>();
        List<Node> children = this.getParentNode().getChildren();
        for (Node child : children) {
            if (child instanceof ImportDeclaration) {
                ImportDeclaration id = (ImportDeclaration)child;
                if (id.isAsterisk()) {
                    List<SymbolReference> usages = id.getUsages();
                    if (usages == null) continue;
                    for (SymbolReference usage : usages) {
                        if (!(usage instanceof SymbolDataAware)) continue;
                        SymbolDataAware sda = (SymbolDataAware)((Object)usage);
                        result.put(sda.getSymbolData().getName(), id);
                    }
                    continue;
                }
                result.put(this.getSymbolName(), id);
                continue;
            }
            if (!(child instanceof TypeDeclaration)) continue;
            TypeDeclaration td = (TypeDeclaration)child;
            result.put(td.getName(), td);
        }
        return result;
    }

    @Override
    public String getSymbolName() {
        return this.name.getName();
    }
}

