/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolData;
import org.walkmod.javalang.ast.SymbolDataAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.VariableDeclaratorId;
import org.walkmod.javalang.ast.expr.AnnotationExpr;

public abstract class BaseParameter
extends Node
implements SymbolDataAware<SymbolData>,
SymbolDefinition {
    private static final long serialVersionUID = -920000439540828718L;
    private int modifiers;
    private List<AnnotationExpr> annotations;
    private VariableDeclaratorId id;
    private SymbolData symbolData;
    private List<SymbolReference> usages;
    private int scopeLevel = 0;

    public BaseParameter() {
    }

    public BaseParameter(VariableDeclaratorId id) {
        this.setId(id);
    }

    public BaseParameter(int modifiers, VariableDeclaratorId id) {
        this.setModifiers(modifiers);
        this.setId(id);
    }

    public BaseParameter(int modifiers, List<AnnotationExpr> annotations, VariableDeclaratorId id) {
        this.setModifiers(modifiers);
        this.setAnnotations(annotations);
        this.setId(id);
    }

    public BaseParameter(int beginLine, int beginColumn, int endLine, int endColumn, int modifiers, List<AnnotationExpr> annotations, VariableDeclaratorId id) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setModifiers(modifiers);
        this.setAnnotations(annotations);
        this.setId(id);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (child instanceof AnnotationExpr && this.annotations != null) {
                LinkedList<AnnotationExpr> annotationAux = new LinkedList<AnnotationExpr>(this.annotations);
                result = annotationAux.remove(child);
                this.annotations = annotationAux;
            }
            if (child == this.id && this.id != null) {
                this.id = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.annotations != null) {
            children.addAll(this.annotations);
        }
        if (this.id != null) {
            children.add(this.id);
        }
        return children;
    }

    public List<AnnotationExpr> getAnnotations() {
        return this.annotations;
    }

    public VariableDeclaratorId getId() {
        return this.id;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setAnnotations(List<AnnotationExpr> annotations) {
        this.annotations = annotations;
        this.setAsParentNodeOf(annotations);
    }

    public void setId(VariableDeclaratorId id) {
        if (this.id != null) {
            this.updateReferences(this.id);
        }
        this.id = id;
        this.setAsParentNodeOf(id);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public SymbolData getSymbolData() {
        return this.symbolData;
    }

    @Override
    public void setSymbolData(SymbolData symbolData) {
        this.symbolData = symbolData;
    }

    @Override
    public List<SymbolReference> getUsages() {
        return this.usages;
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        return null;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
        this.usages = usages;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        return false;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
        this.scopeLevel = scopeLevel;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        if (usage != null) {
            usage.setSymbolDefinition(this);
            if (this.usages == null) {
                this.usages = new LinkedList<SymbolReference>();
            }
            return this.usages.add(usage);
        }
        return false;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<AnnotationExpr> auxAnnotations;
        boolean update = false;
        if (this.annotations != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxAnnotations = new LinkedList<AnnotationExpr>(this.annotations)))) {
            this.annotations = auxAnnotations;
        }
        if (!update && this.id == oldChild) {
            this.setId((VariableDeclaratorId)newChild);
            update = true;
        }
        return update;
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public String getSymbolName() {
        return this.getId().getName();
    }
}

