/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.TypeParameter;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.body.TypeDeclaration;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;

public final class ClassOrInterfaceDeclaration
extends TypeDeclaration {
    private boolean interface_;
    private List<TypeParameter> typeParameters;
    private List<ClassOrInterfaceType> extendsList;
    private List<ClassOrInterfaceType> implementsList;

    public ClassOrInterfaceDeclaration() {
    }

    public ClassOrInterfaceDeclaration(int modifiers, boolean isInterface, String name) {
        this.interface_ = isInterface;
        this.setModifiers(modifiers);
        this.setName(name);
    }

    public ClassOrInterfaceDeclaration(JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, boolean isInterface, String name, List<TypeParameter> typeParameters, List<ClassOrInterfaceType> extendsList, List<ClassOrInterfaceType> implementsList, List<BodyDeclaration> members) {
        this.interface_ = isInterface;
        this.setModifiers(modifiers);
        this.setName(name);
        this.setTypeParameters(typeParameters);
        this.setExtends(extendsList);
        this.setImplements(implementsList);
        this.setJavaDoc(javaDoc);
        this.setMembers(members);
    }

    public ClassOrInterfaceDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, boolean isInterface, String name, List<TypeParameter> typeParameters, List<ClassOrInterfaceType> extendsList, List<ClassOrInterfaceType> implementsList, List<BodyDeclaration> members) {
        super(beginLine, beginColumn, endLine, endColumn, annotations, javaDoc, modifiers, name, members);
        this.interface_ = isInterface;
        this.setTypeParameters(typeParameters);
        this.setExtends(extendsList);
        this.setImplements(implementsList);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child))) {
            if (child instanceof TypeParameter) {
                if (this.typeParameters != null) {
                    LinkedList<TypeParameter> tp = new LinkedList<TypeParameter>(this.typeParameters);
                    result = tp.remove(child);
                    this.typeParameters = tp;
                }
            } else if (child instanceof ClassOrInterfaceType) {
                if (this.extendsList != null) {
                    LinkedList<ClassOrInterfaceType> extendsListAux = new LinkedList<ClassOrInterfaceType>(this.extendsList);
                    result = extendsListAux.remove(child);
                    this.extendsList = extendsListAux;
                }
                if (!result && this.implementsList != null) {
                    LinkedList<ClassOrInterfaceType> implementsListAux = new LinkedList<ClassOrInterfaceType>(this.implementsList);
                    result = implementsListAux.remove(child);
                    this.implementsList = implementsListAux;
                }
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.typeParameters != null) {
            children.addAll(this.typeParameters);
        }
        if (this.extendsList != null) {
            children.addAll(this.extendsList);
        }
        if (this.implementsList != null) {
            children.addAll(this.implementsList);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<ClassOrInterfaceType> getExtends() {
        return this.extendsList;
    }

    public List<ClassOrInterfaceType> getImplements() {
        return this.implementsList;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean isInterface() {
        return this.interface_;
    }

    public void setExtends(List<ClassOrInterfaceType> extendsList) {
        this.extendsList = extendsList;
        this.setAsParentNodeOf(extendsList);
    }

    public void setImplements(List<ClassOrInterfaceType> implementsList) {
        this.implementsList = implementsList;
        this.setAsParentNodeOf(implementsList);
    }

    public void setInterface(boolean interface_) {
        this.interface_ = interface_;
    }

    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
        this.setAsParentNodeOf(typeParameters);
    }

    @Override
    public void merge(TypeDeclaration remoteTypeDeclaration, MergeEngine configuration) {
        super.merge(remoteTypeDeclaration, configuration);
        LinkedList<TypeParameter> typeParametersList = new LinkedList<TypeParameter>();
        configuration.apply(this.getTypeParameters(), ((ClassOrInterfaceDeclaration)remoteTypeDeclaration).getTypeParameters(), typeParametersList, TypeParameter.class);
        if (!typeParametersList.isEmpty()) {
            this.setTypeParameters(typeParametersList);
        } else {
            this.setTypeParameters(null);
        }
        LinkedList<ClassOrInterfaceType> implementsList = new LinkedList<ClassOrInterfaceType>();
        configuration.apply(this.getImplements(), ((ClassOrInterfaceDeclaration)remoteTypeDeclaration).getImplements(), implementsList, ClassOrInterfaceType.class);
        if (!implementsList.isEmpty()) {
            this.setImplements(implementsList);
        } else {
            this.setImplements(null);
        }
        LinkedList<ClassOrInterfaceType> extendsList = new LinkedList<ClassOrInterfaceType>();
        configuration.apply(this.getExtends(), ((ClassOrInterfaceDeclaration)remoteTypeDeclaration).getExtends(), extendsList, ClassOrInterfaceType.class);
        if (!extendsList.isEmpty()) {
            this.setExtends(extendsList);
        } else {
            this.setExtends(null);
        }
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean update = super.replaceChildNode(oldChild, newChild);
        if (!update) {
            LinkedList<TypeParameter> auxTypeParams;
            LinkedList<ClassOrInterfaceType> auxImplementsList;
            LinkedList<ClassOrInterfaceType> auxExtends;
            if (this.extendsList != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxExtends = new LinkedList<ClassOrInterfaceType>(this.extendsList)))) {
                this.extendsList = auxExtends;
            }
            if (!update && this.implementsList != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxImplementsList = new LinkedList<ClassOrInterfaceType>(this.implementsList)))) {
                this.implementsList = auxImplementsList;
            }
            if (!update && this.typeParameters != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxTypeParams = new LinkedList<TypeParameter>(this.typeParameters)))) {
                this.typeParameters = auxTypeParams;
            }
        }
        return update;
    }

    @Override
    public ClassOrInterfaceDeclaration clone() throws CloneNotSupportedException {
        return new ClassOrInterfaceDeclaration(this.clone(this.getJavaDoc()), this.getModifiers(), this.clone(this.getAnnotations()), this.interface_, this.getName(), this.clone(this.getTypeParameters()), this.clone(this.getExtends()), this.clone(this.getImplements()), this.clone(this.getMembers()));
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Map<String, SymbolDefinition> result = super.getTypeDefinitions();
        if (this.typeParameters != null) {
            for (TypeParameter tp : this.typeParameters) {
                result.put(tp.getSymbolName(), tp);
            }
        }
        return result;
    }
}

