/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.ConstructorSymbolData;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolDataAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.TypeParameter;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.body.Parameter;
import org.walkmod.javalang.ast.body.TypeDeclaration;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.comparators.ConstructorDeclarationComparator;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.Mergeable;

public final class ConstructorDeclaration
extends BodyDeclaration
implements Mergeable<ConstructorDeclaration>,
SymbolDataAware<ConstructorSymbolData>,
SymbolDefinition {
    private int modifiers;
    private List<TypeParameter> typeParameters;
    private String name;
    private List<Parameter> parameters;
    private List<ClassOrInterfaceType> throws_;
    private BlockStmt block;
    private ConstructorSymbolData symbolData;
    private List<SymbolReference> usages;
    private List<SymbolReference> bodyReferences;
    private int scopeLevel = 0;

    public ConstructorDeclaration() {
    }

    public ConstructorDeclaration(int modifiers, String name) {
        this.modifiers = modifiers;
        this.name = name;
    }

    public ConstructorDeclaration(JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, String name, List<Parameter> parameters, List<ClassOrInterfaceType> throws_, BlockStmt block) {
        super(annotations, javaDoc);
        this.modifiers = modifiers;
        this.typeParameters = typeParameters;
        this.name = name;
        this.parameters = parameters;
        this.throws_ = throws_;
        this.block = block;
    }

    public ConstructorDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, String name, List<Parameter> parameters, List<ClassOrInterfaceType> throws_, BlockStmt block) {
        super(beginLine, beginColumn, endLine, endColumn, annotations, javaDoc);
        this.modifiers = modifiers;
        this.typeParameters = typeParameters;
        this.name = name;
        this.parameters = parameters;
        this.throws_ = throws_;
        this.block = block;
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child))) {
            if (child instanceof TypeParameter) {
                if (this.typeParameters != null) {
                    LinkedList<TypeParameter> typeParametersAux = new LinkedList<TypeParameter>(this.typeParameters);
                    result = typeParametersAux.remove(child);
                    this.typeParameters = typeParametersAux;
                }
            } else if (child instanceof Parameter) {
                if (this.parameters != null) {
                    LinkedList<Parameter> paramsAux = new LinkedList<Parameter>(this.parameters);
                    result = paramsAux.remove(child);
                    this.parameters = paramsAux;
                }
            } else if (child instanceof ClassOrInterfaceType) {
                if (this.throws_ != null) {
                    LinkedList<ClassOrInterfaceType> throwsAux = new LinkedList<ClassOrInterfaceType>(this.throws_);
                    result = throwsAux.remove(child);
                    this.throws_ = throwsAux;
                }
            } else if (child == this.block && this.block != null) {
                this.block = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.typeParameters != null) {
            children.addAll(this.typeParameters);
        }
        if (this.parameters != null) {
            children.addAll(this.parameters);
        }
        if (this.throws_ != null) {
            children.addAll(this.throws_);
        }
        if (this.block != null) {
            children.add(this.block);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public BlockStmt getBlock() {
        return this.block;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<ClassOrInterfaceType> getThrows() {
        return this.throws_;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public void setBlock(BlockStmt block) {
        this.block = block;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setThrows(List<ClassOrInterfaceType> throws_) {
        this.throws_ = throws_;
    }

    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
    }

    public Comparator<?> getIdentityComparator() {
        return new ConstructorDeclarationComparator();
    }

    public void merge(ConstructorDeclaration remote, MergeEngine configuration) {
        super.merge(remote, configuration);
        this.setBlock((BlockStmt)configuration.apply((Object)this.getBlock(), (Object)remote.getBlock(), BlockStmt.class));
        LinkedList<Parameter> resultParams = new LinkedList<Parameter>();
        configuration.apply(this.getParameters(), remote.getParameters(), resultParams, Parameter.class);
        if (!resultParams.isEmpty()) {
            this.setParameters(resultParams);
        } else {
            this.setParameters(null);
        }
        LinkedList<TypeParameter> resultTypeParams = new LinkedList<TypeParameter>();
        configuration.apply(this.getTypeParameters(), remote.getTypeParameters(), resultTypeParams, TypeParameter.class);
        if (!resultTypeParams.isEmpty()) {
            this.setTypeParameters(resultTypeParams);
        } else {
            this.setTypeParameters(null);
        }
        LinkedList<ClassOrInterfaceType> resultThrows = new LinkedList<ClassOrInterfaceType>();
        configuration.apply(this.getThrows(), remote.getThrows(), resultThrows, ClassOrInterfaceType.class);
        if (!resultThrows.isEmpty()) {
            this.setThrows(resultThrows);
        } else {
            this.setThrows(null);
        }
    }

    @Override
    public ConstructorSymbolData getSymbolData() {
        return this.symbolData;
    }

    @Override
    public void setSymbolData(ConstructorSymbolData symbolData) {
        this.symbolData = symbolData;
    }

    @Override
    public List<SymbolReference> getUsages() {
        return this.usages;
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        return this.bodyReferences;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
        this.usages = usages;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
        this.bodyReferences = bodyReferences;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
        this.scopeLevel = scopeLevel;
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        int scope;
        SymbolDefinition definition;
        if (bodyReference != null && (definition = bodyReference.getSymbolDefinition()) != null && (scope = definition.getScopeLevel()) <= this.scopeLevel) {
            if (this.bodyReferences == null) {
                this.bodyReferences = new LinkedList<SymbolReference>();
            }
            return this.bodyReferences.add(bodyReference);
        }
        return false;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        if (usage != null) {
            usage.setSymbolDefinition(this);
            if (this.usages == null) {
                this.usages = new LinkedList<SymbolReference>();
            }
            return this.usages.add(usage);
        }
        return false;
    }

    @Override
    public TypeDeclaration getParentNode() {
        return (TypeDeclaration)super.getParentNode();
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<ClassOrInterfaceType> auxThrows;
        LinkedList<TypeParameter> auxTypeParams;
        LinkedList<Parameter> auxParameters;
        boolean update = super.replaceChildNode(oldChild, newChild);
        if (!update && this.parameters != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxParameters = new LinkedList<Parameter>(this.parameters)))) {
            this.parameters = auxParameters;
        }
        if (!update && this.typeParameters != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxTypeParams = new LinkedList<TypeParameter>(this.typeParameters)))) {
            this.typeParameters = auxTypeParams;
        }
        if (!update && this.throws_ != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxThrows = new LinkedList<ClassOrInterfaceType>(this.throws_)))) {
            this.throws_ = auxThrows;
        }
        return update;
    }

    @Override
    public ConstructorDeclaration clone() throws CloneNotSupportedException {
        return new ConstructorDeclaration(this.clone(this.getJavaDoc()), this.getModifiers(), this.clone(this.getAnnotations()), this.clone(this.getTypeParameters()), this.getName(), this.clone(this.getParameters()), this.clone(this.getThrows()), this.clone(this.getBlock()));
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Map<String, SymbolDefinition> result = super.getVariableDefinitions();
        if (this.parameters != null) {
            for (Parameter param : this.parameters) {
                result.put(param.getSymbolName(), param);
            }
        }
        return result;
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Map<String, SymbolDefinition> result = super.getVariableDefinitions();
        if (this.typeParameters != null) {
            for (TypeParameter tp : this.typeParameters) {
                result.put(tp.getSymbolName(), tp);
            }
        }
        return result;
    }

    @Override
    public String getSymbolName() {
        return this.name;
    }
}

