/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolData;
import org.walkmod.javalang.ast.SymbolDataAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.EnumDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.comparators.EnumConstantDeclarationComparator;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.Mergeable;

public final class EnumConstantDeclaration
extends BodyDeclaration
implements Mergeable<EnumConstantDeclaration>,
SymbolDefinition,
SymbolDataAware<SymbolData> {
    private String name;
    private List<Expression> args;
    private List<BodyDeclaration> classBody;
    private List<SymbolReference> usages;
    private List<SymbolReference> bodyReferences;
    private int scopeLevel = 0;
    private SymbolData symbolData = null;

    public EnumConstantDeclaration() {
    }

    public EnumConstantDeclaration(String name) {
        this.name = name;
    }

    public EnumConstantDeclaration(JavadocComment javaDoc, List<AnnotationExpr> annotations, String name, List<Expression> args, List<BodyDeclaration> classBody) {
        super(annotations, javaDoc);
        this.name = name;
        this.setArgs(args);
        this.setClassBody(classBody);
    }

    public EnumConstantDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, JavadocComment javaDoc, List<AnnotationExpr> annotations, String name, List<Expression> args, List<BodyDeclaration> classBody) {
        super(beginLine, beginColumn, endLine, endColumn, annotations, javaDoc);
        this.name = name;
        this.setArgs(args);
        this.setClassBody(classBody);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child))) {
            if (child instanceof Expression) {
                if (this.args != null) {
                    LinkedList<Expression> argsAux = new LinkedList<Expression>(this.args);
                    result = argsAux.remove(child);
                    this.args = argsAux;
                }
            } else if (child instanceof BodyDeclaration && this.classBody != null) {
                LinkedList<BodyDeclaration> classBodyAux = new LinkedList<BodyDeclaration>(this.classBody);
                result = classBodyAux.remove(child);
                this.classBody = classBodyAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.args != null) {
            children.addAll(this.args);
        }
        if (this.classBody != null) {
            children.addAll(this.classBody);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<Expression> getArgs() {
        return this.args;
    }

    public List<BodyDeclaration> getClassBody() {
        return this.classBody;
    }

    public String getName() {
        return this.name;
    }

    public void setArgs(List<Expression> args) {
        this.args = args;
        this.setAsParentNodeOf(args);
    }

    public void setClassBody(List<BodyDeclaration> classBody) {
        this.classBody = classBody;
        this.setAsParentNodeOf(classBody);
    }

    public void setName(String name) {
        this.name = name;
    }

    public Comparator<?> getIdentityComparator() {
        return new EnumConstantDeclarationComparator();
    }

    public void merge(EnumConstantDeclaration remote, MergeEngine configuration) {
        super.merge(remote, configuration);
        LinkedList<BodyDeclaration> resultClassBody = new LinkedList<BodyDeclaration>();
        configuration.apply(this.getClassBody(), remote.getClassBody(), resultClassBody, BodyDeclaration.class);
        if (!resultClassBody.isEmpty()) {
            this.setClassBody(resultClassBody);
        } else {
            this.setClassBody(null);
        }
        LinkedList<Expression> resultArgs = new LinkedList<Expression>();
        configuration.apply(this.getArgs(), remote.getArgs(), resultArgs, Expression.class);
        if (!resultArgs.isEmpty()) {
            this.setArgs(resultArgs);
        } else {
            this.setArgs(null);
        }
    }

    @Override
    public EnumDeclaration getParentNode() {
        return (EnumDeclaration)super.getParentNode();
    }

    @Override
    public List<SymbolReference> getUsages() {
        return this.usages;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
        this.usages = usages;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        if (usage != null) {
            usage.setSymbolDefinition(this);
            if (this.usages == null) {
                this.usages = new LinkedList<SymbolReference>();
            }
            return this.usages.add(usage);
        }
        return false;
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        return this.bodyReferences;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
        this.bodyReferences = bodyReferences;
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        int scope;
        SymbolDefinition definition;
        if (bodyReference != null && (definition = bodyReference.getSymbolDefinition()) != null && (scope = definition.getScopeLevel()) <= this.scopeLevel) {
            if (this.bodyReferences == null) {
                this.bodyReferences = new LinkedList<SymbolReference>();
            }
            return this.bodyReferences.add(bodyReference);
        }
        return false;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
        this.scopeLevel = scopeLevel;
    }

    @Override
    public SymbolData getSymbolData() {
        return this.symbolData;
    }

    @Override
    public void setSymbolData(SymbolData symbolData) {
        this.symbolData = symbolData;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<BodyDeclaration> auxClassBody;
        LinkedList<Expression> auxArgs;
        boolean update = super.replaceChildNode(oldChild, newChild);
        if (!update && this.args != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxArgs = new LinkedList<Expression>(this.args)))) {
            this.args = auxArgs;
        }
        if (!update && this.classBody != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxClassBody = new LinkedList<BodyDeclaration>(this.classBody)))) {
            this.classBody = auxClassBody;
        }
        return update;
    }

    @Override
    public EnumConstantDeclaration clone() throws CloneNotSupportedException {
        return new EnumConstantDeclaration(this.clone(this.getJavaDoc()), this.clone(this.getAnnotations()), this.name, this.clone(this.getArgs()), this.clone(this.getClassBody()));
    }

    @Override
    public String getSymbolName() {
        return this.name;
    }
}

