/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.EnumConstantDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.body.TypeDeclaration;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class EnumDeclaration
extends TypeDeclaration {
    private List<ClassOrInterfaceType> implementsList;
    private List<EnumConstantDeclaration> entries;

    public EnumDeclaration() {
    }

    public EnumDeclaration(int modifiers, String name) {
        super(modifiers, name);
    }

    public EnumDeclaration(JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, String name, List<ClassOrInterfaceType> implementsList, List<EnumConstantDeclaration> entries, List<BodyDeclaration> members) {
        this(0, 0, 0, 0, javaDoc, modifiers, annotations, name, implementsList, entries, members);
    }

    public EnumDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, String name, List<ClassOrInterfaceType> implementsList, List<EnumConstantDeclaration> entries, List<BodyDeclaration> members) {
        super(beginLine, beginColumn, endLine, endColumn, annotations, javaDoc, modifiers, name, members);
        this.setImplements(implementsList);
        this.setEntries(entries);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child))) {
            if (child instanceof ClassOrInterfaceType) {
                if (this.implementsList != null) {
                    LinkedList<ClassOrInterfaceType> auxImplementsList = new LinkedList<ClassOrInterfaceType>(this.implementsList);
                    result = auxImplementsList.remove(child);
                    this.implementsList = auxImplementsList;
                }
            } else if (child instanceof EnumConstantDeclaration && this.entries != null) {
                LinkedList<EnumConstantDeclaration> entriesAux = new LinkedList<EnumConstantDeclaration>();
                result = entriesAux.remove(child);
                this.entries = entriesAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.implementsList != null) {
            children.addAll(this.implementsList);
        }
        if (this.entries != null) {
            children.addAll(this.entries);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<EnumConstantDeclaration> getEntries() {
        return this.entries;
    }

    public List<ClassOrInterfaceType> getImplements() {
        return this.implementsList;
    }

    public void setEntries(List<EnumConstantDeclaration> entries) {
        this.entries = entries;
        this.setAsParentNodeOf(entries);
    }

    public void setImplements(List<ClassOrInterfaceType> implementsList) {
        this.implementsList = implementsList;
        this.setAsParentNodeOf(implementsList);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<EnumConstantDeclaration> auxEntries;
        LinkedList<ClassOrInterfaceType> auxImplementsList;
        boolean update = super.replaceChildNode(oldChild, newChild);
        if (!update && this.implementsList != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxImplementsList = new LinkedList<ClassOrInterfaceType>(this.implementsList)))) {
            this.implementsList = auxImplementsList;
        }
        if (!update && this.entries != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxEntries = new LinkedList<EnumConstantDeclaration>(this.entries)))) {
            this.entries = auxEntries;
        }
        return update;
    }

    @Override
    public EnumDeclaration clone() throws CloneNotSupportedException {
        return new EnumDeclaration(this.clone(this.getJavaDoc()), this.getModifiers(), this.clone(this.getAnnotations()), this.getName(), this.clone(this.getImplements()), this.clone(this.getEntries()), this.clone(this.getMembers()));
    }
}

