/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.Comparator;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.comparators.InitializerDeclarationComparator;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.Mergeable;

public final class InitializerDeclaration
extends BodyDeclaration
implements Mergeable<InitializerDeclaration> {
    private boolean isStatic;
    private BlockStmt block;

    public InitializerDeclaration() {
    }

    public InitializerDeclaration(boolean isStatic, BlockStmt block) {
        this.isStatic = isStatic;
        this.setBlock(block);
    }

    public InitializerDeclaration(JavadocComment javaDoc, boolean isStatic, BlockStmt block) {
        super(null, javaDoc);
        this.isStatic = isStatic;
        this.setBlock(block);
    }

    public InitializerDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, JavadocComment javaDoc, boolean isStatic, BlockStmt block) {
        super(beginLine, beginColumn, endLine, endColumn, null, javaDoc);
        this.isStatic = isStatic;
        this.setBlock(block);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child)) && child == this.block && this.block != null) {
            this.block = null;
            result = true;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.block != null) {
            children.add(this.block);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public BlockStmt getBlock() {
        return this.block;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setBlock(BlockStmt block) {
        if (this.block != null) {
            this.updateReferences(this.block);
        }
        this.block = block;
        this.setAsParentNodeOf(block);
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public Comparator<?> getIdentityComparator() {
        return new InitializerDeclarationComparator();
    }

    public void merge(InitializerDeclaration remote, MergeEngine configuration) {
        super.merge(remote, configuration);
        this.setBlock((BlockStmt)configuration.apply((Object)this.getBlock(), (Object)remote.getBlock(), BlockStmt.class));
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean update = super.replaceChildNode(oldChild, newChild);
        if (!update && oldChild == this.block) {
            this.setBlock((BlockStmt)newChild);
            update = true;
        }
        return update;
    }

    @Override
    public InitializerDeclaration clone() throws CloneNotSupportedException {
        return new InitializerDeclaration(this.clone(this.getJavaDoc()), this.isStatic, this.clone(this.getBlock()));
    }
}

