/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.comparators.AnnotationExprComparator;
import org.walkmod.merger.Mergeable;

public abstract class AnnotationExpr
extends Expression
implements Mergeable<AnnotationExpr>,
SymbolReference {
    protected NameExpr name;
    private SymbolDefinition symbolDefinition;

    public AnnotationExpr() {
    }

    public AnnotationExpr(int beginLine, int beginColumn, int endLine, int endColumn) {
        super(beginLine, beginColumn, endLine, endColumn);
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.name != null) {
            children.add(this.name);
        }
        return children;
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && this.name == child) {
            this.name = null;
            result = true;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    public NameExpr getName() {
        return this.name;
    }

    public void setName(NameExpr name) {
        if (this.name != null) {
            this.updateReferences(this.name);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
    }

    public Comparator<?> getIdentityComparator() {
        return new AnnotationExprComparator();
    }

    @Override
    public String getPrettySource(char indentationChar, int indentationLevel, int indentationSize) {
        String text = super.getPrettySource(indentationChar, 0, 0);
        text = text + " ";
        return text;
    }

    @Override
    public SymbolDefinition getSymbolDefinition() {
        return this.symbolDefinition;
    }

    @Override
    public void setSymbolDefinition(SymbolDefinition symbolDefinition) {
        this.symbolDefinition = symbolDefinition;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        if (this.name == oldChild) {
            this.setName((NameExpr)newChild);
            return true;
        }
        return false;
    }
}

