/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class ArrayAccessExpr
extends Expression {
    private Expression name;
    private Expression index;

    public ArrayAccessExpr() {
    }

    public ArrayAccessExpr(Expression name, Expression index) {
        this.setName(name);
        this.setIndex(index);
    }

    public ArrayAccessExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression name, Expression index) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setName(name);
        this.setIndex(index);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.name != null && this.name == child) {
                this.name = null;
                result = true;
            }
            if (!result && this.index != null && this.index == child) {
                this.index = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.name != null) {
            children.add(this.name);
        }
        if (this.index != null) {
            children.add(this.index);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getIndex() {
        return this.index;
    }

    public Expression getName() {
        return this.name;
    }

    public void setIndex(Expression index) {
        if (this.index != null) {
            this.updateReferences(this.index);
        }
        this.index = index;
        this.setAsParentNodeOf(index);
    }

    public void setName(Expression name) {
        if (this.name != null) {
            this.updateReferences(this.name);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (this.index == oldChild) {
            this.setIndex((Expression)newChild);
            updated = true;
        }
        if (!updated && this.name == oldChild) {
            this.setName((Expression)newChild);
        }
        return updated;
    }

    @Override
    public ArrayAccessExpr clone() throws CloneNotSupportedException {
        return new ArrayAccessExpr(this.clone(this.name), this.clone(this.index));
    }
}

