/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class AssignExpr
extends Expression {
    private Expression target;
    private Expression value;
    private Operator op;

    public AssignExpr() {
    }

    public AssignExpr(Expression target, Expression value, Operator op) {
        this.setTarget(target);
        this.setValue(value);
        this.setOperator(op);
    }

    public AssignExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression target, Expression value, Operator op) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setTarget(target);
        this.setValue(value);
        this.setOperator(op);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.target != null && this.target == child) {
                this.target = null;
                result = true;
            }
            if (!result && this.value != null && this.value == child) {
                this.value = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.target != null) {
            children.add(this.target);
        }
        if (this.value != null) {
            children.add(this.value);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Operator getOperator() {
        return this.op;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setOperator(Operator op) {
        this.op = op;
    }

    public void setTarget(Expression target) {
        if (this.target != null) {
            this.updateReferences(this.target);
        }
        this.target = target;
        this.setAsParentNodeOf(target);
    }

    public void setValue(Expression value) {
        if (this.value != null) {
            this.updateReferences(this.value);
        }
        this.value = value;
        this.setAsParentNodeOf(value);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (this.target == oldChild) {
            this.setTarget((Expression)newChild);
            updated = true;
        }
        if (!updated && this.value == oldChild) {
            this.setValue((Expression)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public AssignExpr clone() throws CloneNotSupportedException {
        return new AssignExpr(this.clone(this.getTarget()), this.clone(this.getValue()), this.getOperator());
    }

    public static enum Operator {
        assign,
        plus,
        minus,
        star,
        slash,
        and,
        or,
        xor,
        rem,
        lShift,
        rSignedShift,
        rUnsignedShift;

    }
}

