/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class CastExpr
extends Expression {
    private Type type;
    private Expression expr;

    public CastExpr() {
    }

    public CastExpr(Type type, Expression expr) {
        this.setType(type);
        this.setExpr(expr);
    }

    public CastExpr(int beginLine, int beginColumn, int endLine, int endColumn, Type type, Expression expr) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setType(type);
        this.setExpr(expr);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.type != null && this.type == child) {
                this.type = null;
                result = true;
            }
            if (!result && this.expr != null && this.expr == child) {
                this.expr = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.type != null) {
            children.add(this.type);
        }
        if (this.expr != null) {
            children.add(this.expr);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getExpr() {
        return this.expr;
    }

    public Type getType() {
        return this.type;
    }

    public void setExpr(Expression expr) {
        if (this.expr != null) {
            this.updateReferences(this.expr);
        }
        this.expr = expr;
        this.setAsParentNodeOf(expr);
    }

    public void setType(Type type) {
        if (this.type != null) {
            this.updateReferences(this.type);
        }
        this.type = type;
        this.setAsParentNodeOf(type);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (this.type == oldChild) {
            this.setType((Type)newChild);
            updated = true;
        }
        if (!updated && this.expr == oldChild) {
            this.setExpr((Expression)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public CastExpr clone() throws CloneNotSupportedException {
        return new CastExpr(this.clone(this.getType()), this.clone(this.getExpr()));
    }
}

