/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class ConditionalExpr
extends Expression {
    private Expression condition;
    private Expression thenExpr;
    private Expression elseExpr;

    public ConditionalExpr() {
    }

    public ConditionalExpr(Expression condition, Expression thenExpr, Expression elseExpr) {
        this.setCondition(condition);
        this.setThenExpr(thenExpr);
        this.setElseExpr(elseExpr);
    }

    public ConditionalExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression condition, Expression thenExpr, Expression elseExpr) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setCondition(condition);
        this.setThenExpr(thenExpr);
        this.setElseExpr(elseExpr);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.condition == child) {
                this.condition = null;
                result = true;
            }
            if (!result && this.thenExpr == child) {
                this.thenExpr = null;
                result = true;
            }
            if (!result && this.elseExpr == child) {
                this.elseExpr = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.condition != null) {
            children.add(this.condition);
        }
        if (this.thenExpr != null) {
            children.add(this.thenExpr);
        }
        if (this.elseExpr != null) {
            children.add(this.elseExpr);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getElseExpr() {
        return this.elseExpr;
    }

    public Expression getThenExpr() {
        return this.thenExpr;
    }

    public void setCondition(Expression condition) {
        if (this.condition != null) {
            this.updateReferences(this.condition);
        }
        this.condition = condition;
        this.setAsParentNodeOf(condition);
    }

    public void setElseExpr(Expression elseExpr) {
        if (this.elseExpr != null) {
            this.updateReferences(this.elseExpr);
        }
        this.elseExpr = elseExpr;
        this.setAsParentNodeOf(elseExpr);
    }

    public void setThenExpr(Expression thenExpr) {
        if (this.thenExpr != null) {
            this.updateReferences(this.thenExpr);
        }
        this.thenExpr = thenExpr;
        this.setAsParentNodeOf(thenExpr);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (this.condition == oldChild) {
            this.setCondition((Expression)newChild);
            updated = true;
        }
        if (!updated) {
            if (this.thenExpr == oldChild) {
                this.setThenExpr((Expression)newChild);
                updated = true;
            }
            if (!updated && this.elseExpr == oldChild) {
                this.setElseExpr((Expression)newChild);
                updated = true;
            }
        }
        return updated;
    }

    @Override
    public ConditionalExpr clone() throws CloneNotSupportedException {
        return new ConditionalExpr(this.clone(this.getCondition()), this.clone(this.getThenExpr()), this.clone(this.getElseExpr()));
    }
}

