/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public class NameExpr
extends Expression
implements SymbolReference {
    private String name;
    private SymbolDefinition symbolDefinition;

    public NameExpr() {
    }

    public NameExpr(String name) {
        this.name = name;
    }

    public NameExpr(int beginLine, int beginColumn, int endLine, int endColumn, String name) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.name = name;
    }

    @Override
    public boolean removeChild(Node child) {
        return false;
    }

    @Override
    public List<Node> getChildren() {
        return new LinkedList<Node>();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public SymbolDefinition getSymbolDefinition() {
        return this.symbolDefinition;
    }

    @Override
    public void setSymbolDefinition(SymbolDefinition symbolDefinition) {
        this.symbolDefinition = symbolDefinition;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        return false;
    }

    @Override
    public NameExpr clone() throws CloneNotSupportedException {
        return new NameExpr(this.name);
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }
}

