/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.ConstructorSymbolData;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class ObjectCreationExpr
extends Expression
implements SymbolReference,
SymbolDefinition {
    private Expression scope;
    private ClassOrInterfaceType type;
    private List<Type> typeArgs;
    private List<Expression> args;
    private List<BodyDeclaration> anonymousClassBody;
    private SymbolDefinition symbolDefinition;
    private List<SymbolReference> usages;
    private List<SymbolReference> bodyReferences;
    private int scopeLevel = 0;

    public ObjectCreationExpr() {
    }

    public ObjectCreationExpr(Expression scope, ClassOrInterfaceType type, List<Expression> args) {
        this.setScope(scope);
        this.setType(type);
        this.setArgs(args);
    }

    public ObjectCreationExpr(Expression scope, ClassOrInterfaceType type, List<Expression> args, List<BodyDeclaration> anonymousBody) {
        this.setScope(scope);
        this.setType(type);
        this.setArgs(args);
        this.setAnonymousClassBody(anonymousBody);
    }

    public ObjectCreationExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression scope, ClassOrInterfaceType type, List<Type> typeArgs, List<Expression> args, List<BodyDeclaration> anonymousBody) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setScope(scope);
        this.setType(type);
        this.setArgs(args);
        this.setTypeArgs(typeArgs);
        this.setAnonymousClassBody(anonymousBody);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.scope == child) {
                this.scope = null;
                result = true;
            }
            if (!result && this.type == child) {
                this.type = null;
                result = true;
            }
            if (!result && child instanceof Type && this.typeArgs != null) {
                LinkedList<Type> typeArgsAux = new LinkedList<Type>(this.typeArgs);
                result = typeArgsAux.remove(child);
                this.typeArgs = typeArgsAux;
            }
            if (!result && child instanceof Expression && this.args != null) {
                LinkedList<Expression> argsAux = new LinkedList<Expression>(this.args);
                result = argsAux.remove(child);
                this.args = argsAux;
            }
            if (!result && child instanceof BodyDeclaration && this.anonymousClassBody != null) {
                LinkedList<BodyDeclaration> anonymousClassBodyAux = new LinkedList<BodyDeclaration>(this.anonymousClassBody);
                result = anonymousClassBodyAux.remove(child);
                this.anonymousClassBody = anonymousClassBodyAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.scope != null) {
            children.add(this.scope);
        }
        if (this.type != null) {
            children.add(this.type);
        }
        if (this.args != null) {
            children.addAll(this.args);
        }
        if (this.typeArgs != null) {
            children.addAll(this.typeArgs);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<BodyDeclaration> getAnonymousClassBody() {
        return this.anonymousClassBody;
    }

    public List<Expression> getArgs() {
        return this.args;
    }

    public Expression getScope() {
        return this.scope;
    }

    public ClassOrInterfaceType getType() {
        return this.type;
    }

    public List<Type> getTypeArgs() {
        return this.typeArgs;
    }

    public void setAnonymousClassBody(List<BodyDeclaration> anonymousClassBody) {
        this.anonymousClassBody = anonymousClassBody;
        this.setAsParentNodeOf(anonymousClassBody);
    }

    public void setArgs(List<Expression> args) {
        this.args = args;
        this.setAsParentNodeOf(args);
    }

    public void setScope(Expression scope) {
        if (this.scope != null) {
            this.updateReferences(this.scope);
        }
        this.scope = scope;
        this.setAsParentNodeOf(scope);
    }

    public void setType(ClassOrInterfaceType type) {
        if (this.type != null) {
            this.updateReferences(this.type);
        }
        this.type = type;
        this.setAsParentNodeOf(type);
    }

    public void setTypeArgs(List<Type> typeArgs) {
        this.typeArgs = typeArgs;
        this.setAsParentNodeOf(typeArgs);
    }

    @Override
    public ConstructorSymbolData getSymbolData() {
        return (ConstructorSymbolData)super.getSymbolData();
    }

    @Override
    public SymbolDefinition getSymbolDefinition() {
        return this.symbolDefinition;
    }

    @Override
    public void setSymbolDefinition(SymbolDefinition symbolDefinition) {
        this.symbolDefinition = symbolDefinition;
    }

    @Override
    public List<SymbolReference> getUsages() {
        return this.usages;
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        return this.bodyReferences;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
        this.usages = usages;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
        this.bodyReferences = bodyReferences;
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        int scope;
        SymbolDefinition definition;
        if (bodyReference != null && (definition = bodyReference.getSymbolDefinition()) != null && (scope = definition.getScopeLevel()) <= this.scopeLevel) {
            if (this.bodyReferences == null) {
                this.bodyReferences = new LinkedList<SymbolReference>();
            }
            return this.bodyReferences.add(bodyReference);
        }
        return false;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        if (usage != null) {
            usage.setSymbolDefinition(this);
            if (this.usages == null) {
                this.usages = new LinkedList<SymbolReference>();
            }
            return this.usages.add(usage);
        }
        return false;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
        this.scopeLevel = scopeLevel;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<Expression> auxArgs;
        LinkedList<Type> auxTypeArgs;
        boolean updated = false;
        if (oldChild == this.scope) {
            this.setScope((Expression)newChild);
            updated = true;
        }
        if (!updated && oldChild == this.type) {
            this.setType((ClassOrInterfaceType)newChild);
            updated = true;
        }
        if (!updated && this.typeArgs != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxTypeArgs = new LinkedList<Type>(this.typeArgs)))) {
            this.typeArgs = auxTypeArgs;
        }
        if (!updated && this.args != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxArgs = new LinkedList<Expression>(this.args)))) {
            this.args = auxArgs;
        }
        if (!updated && this.anonymousClassBody != null) {
            LinkedList<BodyDeclaration> auxAnonymousClassBody = new LinkedList<BodyDeclaration>(this.anonymousClassBody);
            updated = this.replaceChildNodeInList(oldChild, newChild, auxAnonymousClassBody);
            this.anonymousClassBody = auxAnonymousClassBody;
        }
        return updated;
    }

    @Override
    public ObjectCreationExpr clone() throws CloneNotSupportedException {
        return new ObjectCreationExpr(this.clone(this.scope), this.clone(this.type), this.clone(this.args), this.clone(this.anonymousClassBody));
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public String getSymbolName() {
        return null;
    }
}

