/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.LiteralExpr;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public class StringLiteralExpr
extends LiteralExpr {
    protected String value;

    public StringLiteralExpr() {
    }

    public StringLiteralExpr(String value) {
        this.value = StringLiteralExpr.escape(value);
    }

    public StringLiteralExpr(int beginLine, int beginColumn, int endLine, int endColumn, String value) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.value = StringLiteralExpr.escape(value);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = StringLiteralExpr.escape(value);
    }

    private static String escape(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.append("\\u" + StringLiteralExpr.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.append("\\u0" + StringLiteralExpr.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.append("\\u00" + StringLiteralExpr.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        out.append(ch);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.append("\\u00" + StringLiteralExpr.hex(ch));
                            break;
                        }
                        out.append("\\u000" + StringLiteralExpr.hex(ch));
                        break;
                    }
                }
                continue;
            }
            out.append(ch);
        }
        return out.toString();
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        return false;
    }

    @Override
    public StringLiteralExpr clone() throws CloneNotSupportedException {
        return new StringLiteralExpr(this.value);
    }
}

