/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class VariableDeclarationExpr
extends Expression {
    private int modifiers;
    private List<AnnotationExpr> annotations;
    private Type type;
    private List<VariableDeclarator> vars;

    public VariableDeclarationExpr() {
    }

    public VariableDeclarationExpr(Type type, List<VariableDeclarator> vars) {
        this.setType(type);
        this.setVars(vars);
    }

    public VariableDeclarationExpr(int modifiers, Type type, List<VariableDeclarator> vars) {
        this.modifiers = modifiers;
        this.setType(type);
        this.setVars(vars);
    }

    public VariableDeclarationExpr(int beginLine, int beginColumn, int endLine, int endColumn, int modifiers, List<AnnotationExpr> annotations, Type type, List<VariableDeclarator> vars) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.modifiers = modifiers;
        this.setAnnotations(annotations);
        this.setType(type);
        this.setVars(vars);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.annotations != null && child instanceof AnnotationExpr) {
                LinkedList<AnnotationExpr> annotationsAux = new LinkedList<AnnotationExpr>(this.annotations);
                result = annotationsAux.remove(child);
                this.annotations = annotationsAux;
            }
            if (!result && this.type == child) {
                this.type = null;
                result = true;
            }
            if (!result && this.vars != null && child instanceof VariableDeclarator) {
                LinkedList<VariableDeclarator> varsAux = new LinkedList<VariableDeclarator>(this.vars);
                result = varsAux.remove(child);
                this.vars = varsAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.annotations != null) {
            children.addAll(this.annotations);
        }
        if (this.type != null) {
            children.add(this.type);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<AnnotationExpr> getAnnotations() {
        return this.annotations;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Type getType() {
        return this.type;
    }

    public List<VariableDeclarator> getVars() {
        return this.vars;
    }

    public void setAnnotations(List<AnnotationExpr> annotations) {
        this.annotations = annotations;
        this.setAsParentNodeOf(annotations);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(type);
    }

    public void setVars(List<VariableDeclarator> vars) {
        this.vars = vars;
        this.setAsParentNodeOf(vars);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<VariableDeclarator> auxVars;
        LinkedList<AnnotationExpr> auxAnnotations;
        boolean updated = false;
        if (oldChild == this.type) {
            this.type = (Type)newChild;
            updated = true;
        }
        if (!updated && this.annotations != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxAnnotations = new LinkedList<AnnotationExpr>(this.annotations)))) {
            this.annotations = auxAnnotations;
        }
        if (!updated && this.vars != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxVars = new LinkedList<VariableDeclarator>(this.vars)))) {
            this.vars = auxVars;
        }
        return updated;
    }

    @Override
    public VariableDeclarationExpr clone() throws CloneNotSupportedException {
        return new VariableDeclarationExpr(this.clone(this.type), this.clone(this.vars));
    }
}

