/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class AssertStmt
extends Statement {
    private Expression check;
    private Expression msg;

    public AssertStmt() {
    }

    public AssertStmt(Expression check) {
        this.setCheck(check);
    }

    public AssertStmt(Expression check, Expression msg) {
        this.setCheck(check);
        this.setMessage(msg);
    }

    public AssertStmt(int beginLine, int beginColumn, int endLine, int endColumn, Expression check, Expression msg) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setCheck(check);
        this.setMessage(msg);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.check == child) {
                this.check = null;
                result = true;
            }
            if (!result && this.msg == child) {
                this.msg = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.check != null) {
            children.add(this.check);
        }
        if (this.msg != null) {
            children.add(this.msg);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getCheck() {
        return this.check;
    }

    public Expression getMessage() {
        return this.msg;
    }

    public void setCheck(Expression check) {
        if (this.check != null) {
            this.updateReferences(this.check);
        }
        this.check = check;
        this.setAsParentNodeOf(check);
    }

    public void setMessage(Expression msg) {
        if (this.msg != null) {
            this.updateReferences(this.msg);
        }
        this.msg = msg;
        this.setAsParentNodeOf(msg);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.check) {
            this.setCheck((Expression)newChild);
            updated = true;
        }
        if (!updated && oldChild == this.msg) {
            this.setMessage((Expression)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public AssertStmt clone() throws CloneNotSupportedException {
        return new AssertStmt(this.clone(this.check), this.clone(this.msg));
    }
}

