/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.VariableDeclarationExpr;
import org.walkmod.javalang.ast.stmt.ExpressionStmt;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class BlockStmt
extends Statement
implements ScopeAware {
    private List<Statement> stmts;

    public BlockStmt() {
    }

    public BlockStmt(List<Statement> stmts) {
        this.setStmts(stmts);
    }

    public BlockStmt(int beginLine, int beginColumn, int endLine, int endColumn, List<Statement> stmts) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setStmts(stmts);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && this.stmts != null && child instanceof Statement) {
            LinkedList<Statement> stmtsAux = new LinkedList<Statement>(this.stmts);
            result = stmtsAux.remove(child);
            this.stmts = stmtsAux;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.stmts != null) {
            children.addAll(this.stmts);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<Statement> getStmts() {
        return this.stmts;
    }

    public void setStmts(List<Statement> stmts) {
        this.stmts = stmts;
        this.setAsParentNodeOf(stmts);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<Statement> auxStmts;
        if (this.stmts != null && this.replaceChildNodeInList(oldChild, newChild, auxStmts = new LinkedList<Statement>(this.stmts))) {
            this.stmts = auxStmts;
            return true;
        }
        return false;
    }

    @Override
    public BlockStmt clone() throws CloneNotSupportedException {
        return new BlockStmt(this.clone(this.stmts));
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        Map<String, SymbolDefinition> result = null;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            result = ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        if (result == null) {
            result = new HashMap<String, SymbolDefinition>();
        }
        if (this.stmts != null) {
            for (Statement stmt : this.stmts) {
                VariableDeclarationExpr vde;
                List<VariableDeclarator> vars;
                ExpressionStmt exprStmt;
                Expression expr;
                if (!(stmt instanceof ExpressionStmt) || !((expr = (exprStmt = (ExpressionStmt)stmt).getExpression()) instanceof VariableDeclarationExpr) || (vars = (vde = (VariableDeclarationExpr)expr).getVars()) == null) continue;
                for (VariableDeclarator vd : vars) {
                    result.put(vd.getSymbolName(), vd);
                }
            }
        }
        return result;
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }
}

