/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class DoStmt
extends Statement {
    private Statement body;
    private Expression condition;

    public DoStmt() {
    }

    public DoStmt(Statement body, Expression condition) {
        this.setBody(body);
        this.setCondition(condition);
    }

    public DoStmt(int beginLine, int beginColumn, int endLine, int endColumn, Statement body, Expression condition) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setBody(body);
        this.setCondition(condition);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.body == child) {
                this.body = null;
                result = true;
            }
            if (!result && this.condition == child) {
                this.condition = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.body != null) {
            children.add(this.body);
        }
        if (this.condition != null) {
            children.add(this.condition);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Statement getBody() {
        return this.body;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setBody(Statement body) {
        if (this.body != null) {
            this.updateReferences(this.body);
        }
        this.body = body;
        this.setAsParentNodeOf(body);
    }

    public void setCondition(Expression condition) {
        if (this.condition != null) {
            this.updateReferences(this.condition);
        }
        this.condition = condition;
        this.setAsParentNodeOf(condition);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.body) {
            this.setBody((Statement)newChild);
            updated = true;
        }
        if (!updated && oldChild == this.condition) {
            this.setCondition((Expression)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public DoStmt clone() throws CloneNotSupportedException {
        return new DoStmt(this.clone(this.body), this.clone(this.condition));
    }
}

